/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.analysistools;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.ManifestHelper;
import de.foellix.aql.helper.ManifestInfo;
import de.foellix.aql.system.defaulttools.analysistools.DefaultAnalysisTool;
import de.foellix.aql.system.task.ToolTask;
import java.io.File;

public class DefaultPermissionFinder
extends DefaultAnalysisTool {
    @Override
    public File applyAnalysisTool(ToolTask task) {
        Permissions permissions = null;
        String apk = task.getTaskInfo().getData("%APP_APK%");
        if (apk != null) {
            File apkFile = new File(apk);
            if (apkFile.exists()) {
                ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(apkFile);
                permissions = manifestInfo.getPermissions();
            }
        } else {
            Log.warning("Cannot run PermissionFinder - no APK specified!");
        }
        File answerFile = task.getTaskAnswer().getAnswerFile();
        Answer answer = new Answer();
        if (permissions != null) {
            answer.setPermissions(permissions);
        }
        AnswerHandler.createXML(answer, answerFile);
        return answerFile;
    }
}

