/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.analysistools;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Sinks;
import de.foellix.aql.datastructure.Sources;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.tools.SourceSinkFinder;
import de.foellix.aql.system.defaulttools.analysistools.DefaultSootAnalysisTool;
import de.foellix.aql.system.task.ToolTask;
import java.io.File;

public class DefaultSourceSinkFinder
extends DefaultSootAnalysisTool {
    @Override
    public File applyAnalysisTool(ToolTask task) {
        Sources sources = null;
        Sinks sinks = null;
        String apk = task.getTaskInfo().getData("%APP_APK%");
        if (apk != null) {
            File apkFile = new File(apk);
            if (apkFile.exists()) {
                SourceSinkFinder ssf = task.getTaskInfo().getAllSetVariableNames().contains("%SourcesAndSinks%") ? new SourceSinkFinder(apkFile, new File(task.getTaskInfo().getData("%SourcesAndSinks%"))) : new SourceSinkFinder(apkFile);
                sources = ssf.getSources();
                sinks = ssf.getSinks();
            }
        } else {
            Log.warning("Cannot run IntentInformationFinder - no APK specified!");
        }
        File answerFile = task.getTaskAnswer().getAnswerFile();
        Answer answer = new Answer();
        if (sources != null) {
            answer.setSources(sources);
        }
        if (sinks != null) {
            answer.setSinks(sinks);
        }
        AnswerHandler.createXML(answer, answerFile);
        return answerFile;
    }
}

