/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.operators;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.ConnectHelper;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.operators.DefaultUnifyOperator;
import de.foellix.aql.system.task.OperatorTask;
import java.io.File;
import java.util.LinkedList;
import java.util.Set;

public class DefaultConnectOperator
extends DefaultUnifyOperator {
    public static final int CONNECT_MODE_ALL = 0;
    public static final int CONNECT_MODE_INTRA_APP = 1;
    public static final int CONNECT_MODE_INTER_APP = 2;
    public static final int CONNECT_MODE_FILTER_SOURCE = 3;
    private static final String NEEDLE_SET_RESULT = "void setResult(int,android.content.Intent)";
    private static final String NEEDLE_ON_ACTIVITY_RESULT = "void onActivityResult(int,int,android.content.Intent)";
    private int connectMode;
    private boolean approximate;

    public DefaultConnectOperator() {
        this(0);
    }

    public DefaultConnectOperator(int connectMode) {
        this.connectMode = connectMode;
        this.approximate = false;
    }

    @Override
    public String getName() {
        return super.getName() + (this.approximate ? "*" : "");
    }

    public DefaultConnectOperator setApproximation(boolean enabled) {
        this.approximate = enabled;
        return this;
    }

    @Override
    public File applyOperator(OperatorTask task) {
        File answerFile = FileHelper.getTempFile(".xml");
        AnswerHandler.createXML(this.applyOperatorInner(task), answerFile);
        return answerFile;
    }

    @Override
    public Answer applyOperatorInner(OperatorTask task) {
        Answer temp = null;
        Set<Answer> children = task.getAvailableAnswersOfChildren();
        for (Answer childAnswer : children) {
            if (temp == null) {
                if (children.size() > 1) {
                    temp = childAnswer;
                    continue;
                }
                temp = this.connect(childAnswer, childAnswer);
                continue;
            }
            temp = this.connect(temp, childAnswer);
        }
        return temp;
    }

    public Answer connect(Answer answer, Answer connectWithAnswer) {
        EqualsOptions localEqualsOptions = equalsOptions.copy().setOption(2, true).setOption(1, true);
        Answer returnAnswer = this.unify(answer, connectWithAnswer);
        if (!(this.connectMode != 0 && this.connectMode != 3 || returnAnswer.getIntentfilters() == null || returnAnswer.getIntentfilters().getIntentfilter().isEmpty() || returnAnswer.getIntentsources() == null || returnAnswer.getIntentsources().getIntentsource().isEmpty())) {
            LinkedList<Intentsource> newSources = new LinkedList<Intentsource>();
            for (Intentfilter filter : returnAnswer.getIntentfilters().getIntentfilter()) {
                Target target = new Target();
                target.getAction().addAll(filter.getAction());
                target.getCategory().addAll(filter.getCategory());
                target.getData().addAll(filter.getData());
                if (filter.getReference() == null || filter.getReference().getClassname() == null || filter.getReference().getClassname().isBlank()) continue;
                for (Intentsource source : returnAnswer.getIntentsources().getIntentsource()) {
                    if (!filter.getReference().getClassname().equals(source.getReference().getClassname())) continue;
                    Intentsource newSource = new Intentsource();
                    newSource.setReference(source.getReference());
                    newSource.setTarget(target);
                    boolean add = true;
                    for (Intentsource existentSource : returnAnswer.getIntentsources().getIntentsource()) {
                        if (!EqualsHelper.equals(existentSource, newSource, localEqualsOptions)) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    newSources.add(newSource);
                }
            }
            returnAnswer.getIntentsources().getIntentsource().addAll(newSources);
        }
        if ((this.connectMode == 0 || this.connectMode == 2) && returnAnswer.getIntentsinks() != null && returnAnswer.getIntentsources() != null) {
            LinkedList<Flow> addedFlows = new LinkedList<Flow>();
            for (Intentsink from : returnAnswer.getIntentsinks().getIntentsink()) {
                if (from.getTarget() == null) continue;
                boolean addDefault = false;
                if (from.getTarget() == null) continue;
                if (!(from.getTarget().getCategory() != null && from.getTarget().getCategory().contains("android.intent.category.DEFAULT") || from.getTarget().getAction() == null || from.getTarget().getAction().isEmpty())) {
                    addDefault = true;
                    from.getTarget().getCategory().add("android.intent.category.DEFAULT");
                }
                for (Intentsource to : returnAnswer.getIntentsources().getIntentsource()) {
                    if (to.getTarget() == null || !EqualsHelper.equals(to.getTarget(), from.getTarget(), localEqualsOptions) && (!this.approximate || !EqualsHelper.equalsCategoryAndAction(to.getTarget().getAction(), from.getTarget().getAction(), localEqualsOptions))) continue;
                    if (returnAnswer.getFlows() == null) {
                        returnAnswer.setFlows(new Flows());
                    }
                    Flow flowToAdd = ConnectHelper.connect(from, to);
                    addedFlows.add(flowToAdd);
                    returnAnswer.getFlows().getFlow().add(flowToAdd);
                }
                if (!addDefault) continue;
                from.getTarget().getCategory().remove("android.intent.category.DEFAULT");
            }
            if (returnAnswer.getFlows() != null) {
                LinkedList<Flow> toAdd = new LinkedList<Flow>();
                for (Flow onActivityResultFlow : returnAnswer.getFlows().getFlow()) {
                    Reference fromOnActivityResultFlow = Helper.getFrom(onActivityResultFlow);
                    if (!fromOnActivityResultFlow.getMethod().contains(NEEDLE_ON_ACTIVITY_RESULT)) continue;
                    for (Flow addedFlow : addedFlows) {
                        Reference fromAddedFlow = Helper.getFrom(addedFlow);
                        if (!EqualsHelper.equals(fromAddedFlow.getApp(), fromOnActivityResultFlow.getApp(), localEqualsOptions) || !EqualsHelper.equalsClassString(fromAddedFlow.getClassname(), fromOnActivityResultFlow.getClassname())) continue;
                        Reference toAddedFlow = Helper.getTo(addedFlow);
                        for (Flow setResultFlow : returnAnswer.getFlows().getFlow()) {
                            Reference fromSetResultFlow;
                            Reference toSetResultFlow = Helper.getTo(setResultFlow);
                            if (!Helper.getStatementgenericSafe(toSetResultFlow.getStatement()).contains(NEEDLE_SET_RESULT) || !EqualsHelper.equals(toAddedFlow, fromSetResultFlow = Helper.getFrom(setResultFlow), localEqualsOptions)) continue;
                            toAdd.add(ConnectHelper.connect(toSetResultFlow, fromOnActivityResultFlow));
                        }
                    }
                }
                returnAnswer.getFlows().getFlow().addAll(toAdd);
            }
        }
        if ((this.connectMode == 0 || this.connectMode == 1) && returnAnswer.getFlows() != null) {
            ConnectHelper.computeTransitiveHull(returnAnswer.getFlows(), equalsOptions);
        }
        returnAnswer = Helper.removeRedundant(returnAnswer, equalsOptions);
        return returnAnswer;
    }
}

