/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.operators;

import de.foellix.aql.Log;
import de.foellix.aql.Properties;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Attributes;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.query.FilterQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.TaskAnswer;
import java.io.File;
import java.util.Collection;

public class DefaultFilterOperator
extends DefaultOperator {
    public DefaultFilterOperator() {
        this.execute.setRun(this.getClass().getSimpleName() + " (" + Properties.info().VERSION + ") %ANSWERS%, %ANSWERSHASH%, %ANSWERSHASH_MD5%, %ANSWERSHASH_SHA-1%, %ANSWERSHASH_SHA-256%, %KEY%, %VALUE%, %SOI%, %FILTER_STATEMENT%, %FILTER_LINENUMBER%, %FILTER_METHOD%, %FILTER_CLASS%, %FILTER_APK%");
    }

    @Override
    public File applyOperator(OperatorTask task) {
        File answerFile = FileHelper.getTempFile(".xml");
        AnswerHandler.createXML(this.applyOperatorInner(task), answerFile);
        return answerFile;
    }

    public Answer applyOperatorInner(OperatorTask task) {
        Collection<Question> relatedQuestions = ((FilterQuestion)Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task)).getChildren(false, true);
        Answer temp = null;
        if (relatedQuestions.size() == 1) {
            TaskAnswer tempTA = Storage.getInstance().getData().getTaskFromQuestionTaskMap(relatedQuestions.iterator().next()).getTaskAnswer();
            if (tempTA.getType() == 0) {
                temp = (Answer)tempTA.getAnswer();
            } else if (tempTA.getType() == 1) {
                temp = AnswerHandler.castToAnswer(tempTA.getAnswerFile());
            }
        }
        if (temp == null) {
            Log.error("Could not apply FILTER operator! (Can only be applied on a single AQL-Answer.)");
            return null;
        }
        boolean keyValue = false;
        if (task.getTaskInfo().getData("%KEY%") != null && !task.getTaskInfo().getData("%KEY%").isEmpty() && task.getTaskInfo().getData("%VALUE%") != null && !task.getTaskInfo().getData("%VALUE%").isEmpty()) {
            keyValue = true;
        }
        boolean reference = false;
        if (task.getTaskInfo().getData("%FILTER_STATEMENT%") != null && !task.getTaskInfo().getData("%FILTER_STATEMENT%").isEmpty() || task.getTaskInfo().getData("%FILTER_METHOD%") != null && !task.getTaskInfo().getData("%FILTER_METHOD%").isEmpty() || task.getTaskInfo().getData("%FILTER_CLASS%") != null && !task.getTaskInfo().getData("%FILTER_CLASS%").isEmpty() || task.getTaskInfo().getData("%FILTER_APK%") != null && !task.getTaskInfo().getData("%FILTER_APK%").isEmpty()) {
            reference = true;
        }
        boolean soi = task.getTaskInfo().getData("%SOI%") != null && !task.getTaskInfo().getData("%SOI%").isEmpty();
        int soiType = -1;
        if (soi) {
            soiType = Helper.soiToType(task.getTaskInfo().getData("%SOI%"));
        }
        if (!keyValue && !reference) {
            if (soi) {
                return this.filterOutSOI(temp, soiType);
            }
            return this.filter(temp);
        }
        if (keyValue) {
            return this.filterByKeyValue(temp, task.getTaskInfo().getData("%KEY%"), task.getTaskInfo().getData("%VALUE%"), soiType);
        }
        if (reference) {
            Reference ref = new Reference();
            if (task.getTaskInfo().getData("%FILTER_STATEMENT%") != null && !task.getTaskInfo().getData("%FILTER_STATEMENT%").isEmpty()) {
                if (task.getTaskInfo().getData("%FILTER_LINENUMBER%") != null && !task.getTaskInfo().getData("%FILTER_LINENUMBER%").isEmpty()) {
                    ref.setStatement(Helper.createStatement(task.getTaskInfo().getData("%FILTER_STATEMENT%"), Integer.parseInt(task.getTaskInfo().getData("%FILTER_LINENUMBER%"))));
                } else {
                    ref.setStatement(Helper.createStatement(task.getTaskInfo().getData("%FILTER_STATEMENT%")));
                }
            }
            if (task.getTaskInfo().getData("%FILTER_METHOD%") != null && !task.getTaskInfo().getData("%FILTER_METHOD%").isEmpty()) {
                ref.setMethod(task.getTaskInfo().getData("%FILTER_METHOD%"));
            }
            if (task.getTaskInfo().getData("%FILTER_CLASS%") != null && !task.getTaskInfo().getData("%FILTER_CLASS%").isEmpty()) {
                ref.setClassname(task.getTaskInfo().getData("%FILTER_CLASS%"));
            }
            if (task.getTaskInfo().getData("%FILTER_APK%") != null && !task.getTaskInfo().getData("%FILTER_APK%").isEmpty()) {
                ref.setApp(Helper.createApp(task.getTaskInfo().getData("%FILTER_APK%")));
            }
            return this.filterByReference(temp, ref, soiType);
        }
        return null;
    }

    public Answer filter(Answer answer) {
        Reference ref1;
        int i;
        if (answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size(); ++i) {
                ref1 = answer.getPermissions().getPermission().get(i).getReference();
                if (!this.foundInFlows(answer.getFlows(), ref1)) continue;
                answer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (answer.getPermissions().getPermission().size() == 0) {
                answer.setPermissions(null);
            }
        }
        if (answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size(); ++i) {
                ref1 = answer.getIntentsinks().getIntentsink().get(i).getReference();
                if (!this.foundInFlows(answer.getFlows(), ref1)) continue;
                answer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (answer.getIntentsinks().getIntentsink().size() == 0) {
                answer.setIntentsinks(null);
            }
        }
        if (answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size(); ++i) {
                ref1 = answer.getIntentsources().getIntentsource().get(i).getReference();
                if (!this.foundInFlows(answer.getFlows(), ref1)) continue;
                answer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (answer.getIntentsources().getIntentsource().size() == 0) {
                answer.setIntentsources(null);
            }
        }
        if (answer.getFlows() != null) {
            for (Flow path1 : answer.getFlows().getFlow()) {
                if (path1.getAttributes() == null) continue;
                Attribute removeAttr = null;
                for (Attribute attr : path1.getAttributes().getAttribute()) {
                    if (!attr.getName().equals("complete") || !attr.getValue().equals("true")) continue;
                    removeAttr = attr;
                    break;
                }
                if (removeAttr == null) continue;
                path1.getAttributes().getAttribute().remove(removeAttr);
            }
            for (Flow path1 : answer.getFlows().getFlow()) {
                boolean complete = true;
                Reference path1From = null;
                Reference path1To = null;
                for (Reference reference : path1.getReference()) {
                    if (reference.getType().equals("from")) {
                        path1From = reference;
                        continue;
                    }
                    if (!reference.getType().equals("to")) continue;
                    path1To = reference;
                }
                for (Flow flow : answer.getFlows().getFlow()) {
                    if (path1 == flow) continue;
                    Reference path2From = null;
                    Reference path2To = null;
                    for (Reference refPath2 : flow.getReference()) {
                        if (refPath2.getType().equals("from")) {
                            path2From = refPath2;
                            continue;
                        }
                        if (!refPath2.getType().equals("to")) continue;
                        path2To = refPath2;
                    }
                    if (!EqualsHelper.equals(path1From, path2To) && !EqualsHelper.equals(path1To, path2From)) continue;
                    complete = false;
                }
                if (!complete) continue;
                boolean add = true;
                if (path1.getAttributes() == null) {
                    path1.setAttributes(new Attributes());
                } else {
                    for (Attribute attr : path1.getAttributes().getAttribute()) {
                        if (!attr.getName().equals("complete") || !attr.getValue().equals("true")) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                Attribute attribute = new Attribute();
                attribute.setName("complete");
                attribute.setValue("true");
                path1.getAttributes().getAttribute().add(attribute);
            }
        }
        answer = Helper.removeRedundant(answer, equalsOptions);
        return answer;
    }

    private boolean foundInFlows(Flows flows, Reference reference) {
        if (flows == null) {
            return true;
        }
        for (Flow path : flows.getFlow()) {
            for (Reference compareToReference : path.getReference()) {
                if (!EqualsHelper.equals(reference, compareToReference)) continue;
                return false;
            }
        }
        return true;
    }

    public Answer filterOutSOI(Answer answer, int subjectOfInterest) {
        if (subjectOfInterest == 1) {
            answer.setPermissions(null);
        }
        if (subjectOfInterest == 2) {
            answer.setIntents(null);
        }
        if (subjectOfInterest == 3) {
            answer.setIntentfilters(null);
        }
        if (subjectOfInterest == 7) {
            answer.setSources(null);
        }
        if (subjectOfInterest == 8) {
            answer.setSinks(null);
        }
        if (subjectOfInterest == 5) {
            answer.setIntentsinks(null);
        }
        if (subjectOfInterest == 4) {
            answer.setIntentsources(null);
        }
        if (subjectOfInterest == 0) {
            answer.setFlows(null);
        }
        return answer;
    }

    public Answer filterToSOI(Answer answer, int subjectOfInterest) {
        if (subjectOfInterest != 1) {
            answer.setPermissions(null);
        }
        if (subjectOfInterest != 2) {
            answer.setIntents(null);
        }
        if (subjectOfInterest != 3) {
            answer.setIntentfilters(null);
        }
        if (subjectOfInterest != 7) {
            answer.setSources(null);
        }
        if (subjectOfInterest != 8) {
            answer.setSinks(null);
        }
        if (subjectOfInterest != 5) {
            answer.setIntentsinks(null);
        }
        if (subjectOfInterest != 4) {
            answer.setIntentsources(null);
        }
        if (subjectOfInterest != 0) {
            answer.setFlows(null);
        }
        return answer;
    }

    public Answer filterByKeyValue(Answer answer, String key, String value) {
        return this.filterByKeyValue(answer, key, value, -1);
    }

    public Answer filterByKeyValue(Answer answer, String key, String value, int subjectOfInterest) {
        boolean keep;
        int i;
        if ((subjectOfInterest == -1 || subjectOfInterest == 1) && answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size(); ++i) {
                keep = false;
                if (answer.getPermissions().getPermission().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getPermissions().getPermission().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (answer.getPermissions().getPermission().size() == 0) {
                answer.setPermissions(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 2) && answer.getIntents() != null) {
            for (i = 0; i < answer.getIntents().getIntent().size(); ++i) {
                keep = false;
                if (answer.getIntents().getIntent().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntents().getIntent().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntents().getIntent().remove(i);
                --i;
            }
            if (answer.getIntents().getIntent().size() == 0) {
                answer.setIntents(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 3) && answer.getIntentfilters() != null) {
            for (i = 0; i < answer.getIntentfilters().getIntentfilter().size(); ++i) {
                keep = false;
                if (answer.getIntentfilters().getIntentfilter().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentfilters().getIntentfilter().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentfilters().getIntentfilter().remove(i);
                --i;
            }
            if (answer.getIntentfilters().getIntentfilter().size() == 0) {
                answer.setIntentfilters(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 7) && answer.getSources() != null) {
            for (i = 0; i < answer.getSources().getSource().size(); ++i) {
                keep = false;
                if (answer.getSources().getSource().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getSources().getSource().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getSources().getSource().remove(i);
                --i;
            }
            if (answer.getSources().getSource().size() == 0) {
                answer.setSources(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 7) && answer.getSinks() != null) {
            for (i = 0; i < answer.getSinks().getSink().size(); ++i) {
                keep = false;
                if (answer.getSinks().getSink().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getSinks().getSink().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getSinks().getSink().remove(i);
                --i;
            }
            if (answer.getSinks().getSink().size() == 0) {
                answer.setSinks(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 5) && answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size(); ++i) {
                keep = false;
                if (answer.getIntentsinks().getIntentsink().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentsinks().getIntentsink().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (answer.getIntentsinks().getIntentsink().size() == 0) {
                answer.setIntentsinks(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 4) && answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size(); ++i) {
                keep = false;
                if (answer.getIntentsources().getIntentsource().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentsources().getIntentsource().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (answer.getIntentsources().getIntentsource().size() == 0) {
                answer.setIntentsources(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 0) && answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size(); ++i) {
                keep = false;
                if (answer.getFlows().getFlow().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getFlows().getFlow().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(key) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getFlows().getFlow().remove(i);
                --i;
            }
            if (answer.getFlows().getFlow().size() == 0) {
                answer.setFlows(null);
            }
        }
        return answer;
    }

    public Answer filterByReference(Answer answer, Reference reference) {
        return this.filterByReference(answer, reference, -1);
    }

    public Answer filterByReference(Answer answer, Reference reference, int subjectOfInterest) {
        int i;
        EqualsOptions localOptions = equalsOptions.copy();
        localOptions.setOption(0, true);
        localOptions.setOption(1, false);
        if ((subjectOfInterest == -1 || subjectOfInterest == 1) && answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size(); ++i) {
                if (EqualsHelper.equals(reference, answer.getPermissions().getPermission().get(i).getReference(), localOptions)) continue;
                answer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (answer.getPermissions().getPermission().size() == 0) {
                answer.setPermissions(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 7) && answer.getSources() != null) {
            for (i = 0; i < answer.getSources().getSource().size(); ++i) {
                if (EqualsHelper.equals(reference, answer.getSources().getSource().get(i).getReference(), localOptions)) continue;
                answer.getSources().getSource().remove(i);
                --i;
            }
            if (answer.getSources().getSource().size() == 0) {
                answer.setSources(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 8) && answer.getSinks() != null) {
            for (i = 0; i < answer.getSinks().getSink().size(); ++i) {
                if (EqualsHelper.equals(reference, answer.getSinks().getSink().get(i).getReference(), localOptions)) continue;
                answer.getSinks().getSink().remove(i);
                --i;
            }
            if (answer.getSinks().getSink().size() == 0) {
                answer.setSinks(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 5) && answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size(); ++i) {
                if (EqualsHelper.equals(reference, answer.getIntentsinks().getIntentsink().get(i).getReference(), localOptions)) continue;
                answer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (answer.getIntentsinks().getIntentsink().size() == 0) {
                answer.setIntentsinks(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 4) && answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size(); ++i) {
                if (EqualsHelper.equals(reference, answer.getIntentsources().getIntentsource().get(i).getReference(), localOptions)) continue;
                answer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (answer.getIntentsources().getIntentsource().size() == 0) {
                answer.setIntentsources(null);
            }
        }
        if ((subjectOfInterest == -1 || subjectOfInterest == 0) && answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size(); ++i) {
                boolean remove = true;
                for (Reference temp : answer.getFlows().getFlow().get(i).getReference()) {
                    if (!EqualsHelper.equals(reference, temp, localOptions)) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                answer.getFlows().getFlow().remove(i);
                --i;
            }
            if (answer.getFlows().getFlow().size() == 0) {
                answer.setFlows(null);
            }
        }
        answer = Helper.removeRedundant(answer, equalsOptions);
        return answer;
    }
}

