/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.operators;

import de.foellix.aql.Properties;
import de.foellix.aql.config.Tool;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.defaulttools.operators.DefaultConnectOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultFilterOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultIntersectOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultMinusOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultSignOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultToADOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultToFDOperator;
import de.foellix.aql.system.defaulttools.operators.DefaultUnifyOperator;
import de.foellix.aql.system.task.OperatorTask;
import java.io.File;

public abstract class DefaultOperator
extends DefaultTool {
    public static final String OPERATOR_UNIFY = "UNIFY";
    public static final String OPERATOR_CONNECT = "CONNECT";
    public static final String OPERATOR_CONNECT_APPROX = "CONNECT~";
    public static final String OPERATOR_MINUS = "MINUS";
    public static final String OPERATOR_INTERSECT = "INTERSECT";
    public static final String OPERATOR_FILTER = "FILTER";
    public static final String OPERATOR_SIGN = "SIGN";
    public static final String OPERATOR_TOFD = "TOFD";
    public static final String OPERATOR_TOAD = "TOAD";
    protected static EqualsOptions equalsOptions;

    public DefaultOperator() {
        this.execute.setRun(this.getClass().getSimpleName() + " (" + Properties.info().VERSION + ") %ANSWERS%, %ANSWERSHASH%, %ANSWERSHASH_MD5%, %ANSWERSHASH_SHA-1%, %ANSWERSHASH_SHA-256%");
        if (equalsOptions == null) {
            equalsOptions = EqualsOptions.DEFAULT;
        }
    }

    public static EqualsOptions getEqualsOptions() {
        return equalsOptions;
    }

    public static void setEqualsOptions(EqualsOptions options) {
        equalsOptions = options;
    }

    public static void resetEqualsOptions() {
        equalsOptions = EqualsOptions.DEFAULT;
    }

    public abstract File applyOperator(OperatorTask var1);

    public static Tool getOperator(String operator) {
        if (operator.equals(OPERATOR_UNIFY)) {
            return new DefaultUnifyOperator();
        }
        if (operator.equals(OPERATOR_INTERSECT)) {
            return new DefaultIntersectOperator();
        }
        if (operator.equals(OPERATOR_MINUS)) {
            return new DefaultMinusOperator();
        }
        if (operator.equals(OPERATOR_CONNECT)) {
            return new DefaultConnectOperator();
        }
        if (operator.equals(OPERATOR_CONNECT_APPROX)) {
            return new DefaultConnectOperator().setApproximation(true);
        }
        if (operator.equals(OPERATOR_FILTER)) {
            return new DefaultFilterOperator();
        }
        if (operator.equals(OPERATOR_SIGN)) {
            return new DefaultSignOperator();
        }
        if (operator.equals(OPERATOR_TOFD)) {
            return new DefaultToFDOperator();
        }
        if (operator.equals(OPERATOR_TOAD)) {
            return new DefaultToADOperator();
        }
        return null;
    }
}

