/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.operators;

import com.google.common.io.Files;
import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.tools.APKSigner;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.task.OperatorTask;
import java.io.File;
import java.io.IOException;

public class DefaultSignOperator
extends DefaultOperator {
    @Override
    public File applyOperator(OperatorTask task) {
        File apk = new File(task.getTaskInfo().getData("%ANSWERS%"));
        if (apk.exists()) {
            File signedApk = FileHelper.getTempFile(".apk");
            try {
                Files.copy((File)apk, (File)signedApk);
                File androidPlatformTools = ConfigHandler.getInstance().getAndroidBuildTools();
                if (androidPlatformTools.exists()) {
                    APKSigner signer = new APKSigner(androidPlatformTools);
                    signer.sign(signedApk);
                } else {
                    Log.warning("Could not find Android platform tools in \"" + androidPlatformTools.getAbsolutePath() + "\". Continuing with unsigned APK!");
                }
                return signedApk;
            }
            catch (IOException e) {
                Log.warning("Could not copy APK to be signed from \"" + apk.getAbsolutePath() + "\" to \"" + signedApk + "\"." + Log.getExceptionAppendix(e));
            }
        } else {
            Log.warning("APK to be signed could not be found (" + apk.getAbsolutePath() + ")!");
        }
        return null;
    }
}

