/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.defaulttools.operators;

import com.google.common.io.Files;
import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Sink;
import de.foellix.aql.datastructure.Source;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.TaskAnswer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public abstract class DefaultToToolOperator
extends DefaultOperator {
    @Override
    public File applyOperator(OperatorTask task) {
        TaskAnswer tempTA;
        Collection<Question> relatedQuestions = ((OperatorQuestion)Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task)).getChildren(false);
        Answer temp = null;
        if (relatedQuestions.size() == 1 && (tempTA = Storage.getInstance().getData().getTaskFromQuestionTaskMap(relatedQuestions.iterator().next()).getTaskAnswer()).getType() == 0) {
            temp = (Answer)tempTA.getAnswer();
        }
        if (temp == null) {
            Log.error("Could not apply TOFD operator! (Can only be applied on a single AQL-Answer.)");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> lines = new HashSet<String>();
        if (temp.getSources() != null) {
            for (Source source : temp.getSources().getSource()) {
                lines.add(this.toSource(source.getReference().getStatement()));
            }
        }
        for (String string : lines) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(string);
        }
        if (!sb.isEmpty()) {
            sb.append("\n");
        }
        lines.clear();
        if (temp.getSinks() != null) {
            for (Sink sink : temp.getSinks().getSink()) {
                lines.add(this.toSink(sink.getReference().getStatement()));
            }
        }
        for (String string : lines) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(string);
        }
        try {
            File answerFile = FileHelper.getTempFile(".txt");
            Files.write((byte[])sb.toString().getBytes(), (File)answerFile);
            return answerFile;
        }
        catch (IOException e) {
            Log.error("Cannot write file: " + task.getTaskAnswer().getAnswerFile().getAbsolutePath() + Log.getExceptionAppendix(e));
            return null;
        }
    }

    public abstract String toSource(Statement var1);

    public abstract String toSink(Statement var1);
}

