/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.storage;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.QuestionReference;
import de.foellix.aql.helper.BiMap;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskAnswer;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Data
implements Serializable {
    private static final long serialVersionUID = 8715218638063357419L;
    private final Map<String, TaskAnswer> runAnswerMap = new HashMap<String, TaskAnswer>();
    private final BiMap<Question, Task> questionTaskMap = new BiMap();
    private final Map<QuestionReference, Map<String, PreprocessorTask>> questionReferenceTaskMap = new HashMap<QuestionReference, Map<String, PreprocessorTask>>();
    private long answerFileCounter = 0L;

    public void store(Task task) {
        String hashString = task.getHashableString();
        if (hashString != null) {
            this.runAnswerMap.put(hashString, task.getTaskAnswer());
            Log.msg("Storing answered task: " + task.getTaskAnswer().getAnswerFile().getAbsolutePath() + " [" + hashString + "]", 6);
        } else {
            Log.msg("Task cannot be stored. No hash string available.", 4);
        }
        Storage.getInstance().saveData();
    }

    public TaskAnswer load(Task task) {
        String hashString = task.getHashableString();
        if (hashString != null) {
            return this.runAnswerMap.get(hashString);
        }
        Log.msg("Task cannot be loaded. No hash string available.", 4);
        return null;
    }

    public Map<String, TaskAnswer> getRunAnswerMap() {
        return this.runAnswerMap;
    }

    public void putIntoQuestionTaskMap(Question question, Task task) {
        this.questionTaskMap.put(question, task);
    }

    public Question getQuestionFromQuestionTaskMap(Task task) {
        return this.getQuestionFromQuestionTaskMap(task, false);
    }

    public Question getQuestionFromQuestionTaskMap(Task task, boolean takeConverterIntoAccount) {
        ConverterTask converterTask;
        if (takeConverterIntoAccount && (converterTask = Helper.getConverterParent(task)) != null && converterTask.getChildren().size() == 1) {
            return this.questionTaskMap.getKey(converterTask);
        }
        return this.questionTaskMap.getKey(task);
    }

    public void removeFromQuestionTaskMap(Question question) {
        this.questionTaskMap.remove(question);
    }

    public void removeFromQuestionTaskMap(Task task) {
        Question question = this.questionTaskMap.getKey(task);
        if (question != null) {
            this.questionTaskMap.remove(question);
        }
    }

    public Task getTaskFromQuestionTaskMap(Question question) {
        return this.getTaskFromQuestionTaskMap(question, false);
    }

    public Task getTaskFromQuestionTaskMap(Question question, boolean ignoreConverterTasks) {
        if (ignoreConverterTasks && this.questionTaskMap.get(question).getChildren().size() == 1) {
            Task convereterTask = this.questionTaskMap.get(question);
            if (convereterTask instanceof ConverterTask) {
                return convereterTask.getChildren().iterator().next();
            }
            return convereterTask;
        }
        return this.questionTaskMap.get(question);
    }

    public synchronized File getNewAnswerFile() {
        ++this.answerFileCounter;
        String filename = Helper.addZeroDigits(this.answerFileCounter);
        return new File(Storage.getInstance().getStorageDirectory(), filename);
    }

    public PreprocessorTask getPreprocessorTask(QuestionReference ref, IStringOrQuestion keyword) {
        return this.getPreprocessorTask(ref, keyword.toStringInAnswer());
    }

    public PreprocessorTask getPreprocessorTask(QuestionReference ref, String keyword) {
        if (!this.questionReferenceTaskMap.containsKey(ref)) {
            return null;
        }
        return this.questionReferenceTaskMap.get(ref).get(keyword);
    }

    public void addPreprocessorTask(QuestionReference ref, IStringOrQuestion keyword, PreprocessorTask preprocessorTask) {
        if (!this.questionReferenceTaskMap.containsKey(ref)) {
            this.questionReferenceTaskMap.put(ref, new HashMap());
        }
        this.questionReferenceTaskMap.get(ref).put(keyword.toStringInAnswer(false), preprocessorTask);
    }

    public void wipeCache() {
        this.questionTaskMap.clear();
        this.questionReferenceTaskMap.clear();
    }
}

