/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.storage;

import de.foellix.aql.Log;
import de.foellix.aql.system.storage.Data;
import de.foellix.aql.system.task.TaskAnswer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public class Storage {
    public static final File DEFAULT_STORAGE_DIRECTORY = new File("data/storage");
    public static final String STORAGE_FILE = "storage.ser";
    private File storageDirectory = DEFAULT_STORAGE_DIRECTORY;
    private Data data;
    private static Storage instance = new Storage();

    private Storage() {
        this.storageDirectory.mkdir();
        this.init(true);
    }

    private void init(boolean loadData) {
        if (loadData) {
            this.loadData();
        }
        if (this.data == null) {
            this.data = new Data();
        }
    }

    public static Storage getInstance() {
        return instance;
    }

    public File getStorageDirectory() {
        return this.storageDirectory;
    }

    public void setStorageDirectory(File newStorageDirectory) {
        this.storageDirectory = newStorageDirectory;
        this.storageDirectory.mkdir();
        Log.msg("Relocating storage to " + this.storageDirectory, 4);
        this.reset();
    }

    public Data getData() {
        return this.data;
    }

    private void loadData() {
        File storageFile = new File(this.storageDirectory, STORAGE_FILE);
        if (storageFile.exists()) {
            try {
                FileInputStream fileIn = new FileInputStream(storageFile);
                ObjectInputStream in = new ObjectInputStream(fileIn);
                Object temp = in.readObject();
                if (temp instanceof Data) {
                    this.data = (Data)temp;
                } else {
                    Log.error("Loaded storage file is corrupted or not valid for this version of AQL-System!");
                }
                in.close();
                fileIn.close();
            }
            catch (IOException | ClassNotFoundException e) {
                Log.warning("Could not load storage file: " + storageFile.getAbsolutePath() + Log.getExceptionAppendix(e));
            }
        } else {
            Log.msg("No storage file (" + storageFile.getAbsolutePath() + ") found. Continuing with fresh one.", 4);
        }
        if (this.data != null && this.cleanUp()) {
            this.saveData();
        }
    }

    public void saveData() {
        File storageFile = new File(this.storageDirectory, STORAGE_FILE);
        if (storageFile.getParentFile().exists() && storageFile.getParentFile().isDirectory() || storageFile.getParentFile().mkdirs()) {
            try {
                FileOutputStream fileOut = new FileOutputStream(storageFile);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                out.writeObject(this.data);
                out.close();
                fileOut.close();
            }
            catch (IOException e) {
                Log.error("Could not save storage: " + storageFile + Log.getExceptionAppendix(e));
            }
        } else {
            Log.error("Could not access or create storage directory: " + storageFile.getParentFile().getAbsolutePath());
        }
    }

    private boolean cleanUp() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : this.data.getRunAnswerMap().keySet()) {
            TaskAnswer taskAnswer = this.data.getRunAnswerMap().get(key);
            if (taskAnswer.getAnswerFile().exists()) continue;
            toRemove.add(key);
        }
        for (String key : toRemove) {
            this.data.getRunAnswerMap().remove(key);
        }
        return !toRemove.isEmpty();
    }

    public void reset() {
        this.data = new Data();
    }
}

