/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.converter.DefaultConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.exceptions.FailedExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskRunner;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class ConverterTaskRunner
extends TaskRunner {
    public ConverterTaskRunner(TaskScheduler parent, Task task) {
        super(parent, task);
    }

    @Override
    protected boolean runSpecificRunner() throws CancelExecutionException {
        boolean success;
        File finalResultFile;
        block10: {
            if (this.task.getTool() instanceof DefaultConverter) {
                DefaultConverter defaultConverter = (DefaultConverter)this.task.getTool();
                try {
                    Answer answer = defaultConverter.getConverter().parse((ConverterTask)this.task);
                    finalResultFile = FileHelper.getTempFile(".xml");
                    AnswerHandler.createXML(answer, finalResultFile);
                    success = true;
                }
                catch (Exception e) {
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " execution failed!" + Log.getExceptionAppendix(e));
                }
            }
            if (!this.task.getTool().isExternal()) {
                try {
                    success = this.runInternal();
                    if (success) {
                        File resultWithAsteriskFile = new File(Helper.replaceVariables(this.task.getTool().getExecute().getResult(), this.task, this.task.getParent().getParent().getGlobalVariables()));
                        finalResultFile = FileHelper.waitForResult(resultWithAsteriskFile, this.task);
                        if (finalResultFile == null) {
                            throw new FileNotFoundException("Result file was not generated. Maybe " + Helper.getQualifiedName(this.task.getTool()) + " has not finished properly.\n(" + resultWithAsteriskFile.getAbsolutePath() + ")");
                        }
                        break block10;
                    }
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but did not finish successfully.");
                }
                catch (FileNotFoundException e) {
                    throw new CancelExecutionException(e.getMessage());
                }
            }
            success = this.runExternal();
            if (success) {
                finalResultFile = this.externalAnswerFile;
            } else {
                throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was externally executed but did not finish successfully.");
            }
        }
        this.task.getTaskAnswer().setAnswerFile(finalResultFile);
        Storage.getInstance().getData().store(this.task);
        return success;
    }

    @Override
    protected List<File> getExternalFiles() {
        Question query = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this.task);
        ArrayList<File> files = new ArrayList<File>();
        for (App app : query.getAllApps(true)) {
            String allFiles = app.getFile();
            for (String file : allFiles.replace(", ", ",").split(",")) {
                files.add(new File(file));
            }
        }
        return files;
    }

    @Override
    protected String getExternalQuery() {
        Question query = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this.task);
        String externalQuery = query.toString();
        int i = 0;
        for (App app : query.getAllApps(true)) {
            String allFiles = app.getFile();
            for (String file : allFiles.replace(", ", ",").split(",")) {
                externalQuery = externalQuery.replace(file, "%FILE_" + ++i + "%");
            }
        }
        return externalQuery;
    }
}

