/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.query.FilterQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.AppInfo;
import de.foellix.aql.system.TaskCreator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.FilterOperatorTaskInfo;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import java.io.File;

public class FilterOperatorTask
extends OperatorTask {
    private static final long serialVersionUID = 7627075773642008834L;

    public FilterOperatorTask(TaskCreator taskCreator, FilterOperatorTaskInfo taskInfo, Tool tool) {
        super(taskCreator, taskInfo, tool);
    }

    @Override
    public void refreshVariables(Task child) {
        Question loadedFileQuestion;
        Question loadedQuestion;
        super.refreshVariables(child);
        if (child.getTaskAnswer().getType() == 2) {
            Question loadedFilterQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this);
            Question loadedKeyOrValueQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedFilterQuestion instanceof FilterQuestion) {
                if (((FilterQuestion)loadedFilterQuestion).getFilterPair().getKey() == loadedKeyOrValueQuestion) {
                    this.taskInfo.setData("%KEY%", (String)child.getTaskAnswer().getAnswer());
                } else if (((FilterQuestion)loadedFilterQuestion).getFilterPair().getValue() == loadedKeyOrValueQuestion) {
                    this.taskInfo.setData("%VALUE%", (String)child.getTaskAnswer().getAnswer());
                }
            }
        }
        if (child instanceof PreprocessorTask && (loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this)) instanceof FilterQuestion) {
            FilterQuestion question = (FilterQuestion)loadedQuestion;
            if (child instanceof PreprocessorTask && question.getFilterReference() != null && question.getFilterReference().getExecutedPreprocessorKeywords() != null && !question.getFilterReference().getExecutedPreprocessorKeywords().isEmpty()) {
                for (String keyword : question.getFilterReference().getExecutedPreprocessorKeywords()) {
                    PreprocessorTask loadedPreprocessorTask = Storage.getInstance().getData().getPreprocessorTask(question.getFilterReference(), keyword);
                    if (child != loadedPreprocessorTask) continue;
                    File apkFile = (File)child.getTaskAnswer().getAnswer();
                    AppInfo appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%FILTER_APK%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%FILTER_APK_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%FILTER_APK_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%FILTER_APK_PACKAGE%", appInfo.getPkgName());
                }
            }
        }
        if (child.getTaskAnswer().getType() == 1) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof FilterQuestion && ((FilterQuestion)loadedQuestion).getFilterReference() != null && ((FilterQuestion)loadedQuestion).getFilterReference().getApp() == loadedFileQuestion) {
                File apkFile = (File)child.getTaskAnswer().getAnswer();
                AppInfo appInfo = new AppInfo(apkFile);
                this.taskInfo.setData("%FILTER_APK%", appInfo.getApkFile().getAbsolutePath());
                this.taskInfo.setData("%FILTER_APK_FILENAME%", appInfo.getFilename());
                this.taskInfo.setData("%FILTER_APK_NAME%", appInfo.getAppName());
                this.taskInfo.setData("%FILTER_APK_PACKAGE%", appInfo.getPkgName());
            }
        }
        if (child.getTaskAnswer().getType() == 2) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof FilterQuestion && ((FilterQuestion)loadedQuestion).getFilterReference() != null) {
                Question needle;
                if (((FilterQuestion)loadedQuestion).getFilterReference().getStatement() instanceof Question && (needle = (Question)((FilterQuestion)loadedQuestion).getFilterReference().getStatement()) == loadedFileQuestion) {
                    this.taskInfo.setData("%STATEMENT_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                }
                if (((FilterQuestion)loadedQuestion).getFilterReference().getMethod() instanceof Question && (needle = (Question)((FilterQuestion)loadedQuestion).getFilterReference().getMethod()) == loadedFileQuestion) {
                    this.taskInfo.setData("%METHOD_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                }
                if (((FilterQuestion)loadedQuestion).getFilterReference().getClassname() instanceof Question && (needle = (Question)((FilterQuestion)loadedQuestion).getFilterReference().getClassname()) == loadedFileQuestion) {
                    this.taskInfo.setData("%CLASS_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                }
            }
        }
    }
}

