/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.config.Tool;
import de.foellix.aql.helper.FileWithHash;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskCreator;
import de.foellix.aql.system.task.OperatorTaskInfo;
import de.foellix.aql.system.task.Task;
import java.util.List;

public class OperatorTask
extends Task {
    private static final long serialVersionUID = 7627075773642008834L;

    public OperatorTask(TaskCreator taskCreator, OperatorTaskInfo taskInfo, Tool tool) {
        super(taskCreator, taskInfo, tool);
    }

    @Override
    public void refreshVariables(Task child) {
        List<FileWithHash> answersAsFiles = Helper.getAnswerChildrenAsString(this);
        this.taskInfo.setData("%ANSWERS%", Helper.getAnswerFilesAsString(answersAsFiles));
        if (!this.parent.getParent().getOptions().getFilenameBasedAnswersHash()) {
            String hash256 = Helper.getAnswerFilesAsHash(answersAsFiles, "SHA-256");
            this.taskInfo.setData("%ANSWERSHASH%", hash256);
            this.taskInfo.setData("%ANSWERSHASH_MD5%", Helper.getAnswerFilesAsHash(answersAsFiles, "MD5"));
            this.taskInfo.setData("%ANSWERSHASH_SHA-1%", Helper.getAnswerFilesAsHash(answersAsFiles, "SHA-1"));
            this.taskInfo.setData("%ANSWERSHASH_SHA-256%", hash256);
        } else {
            String hash256 = HashHelper.hash(Helper.getAnswerFilesAsString(answersAsFiles), "SHA-256");
            this.taskInfo.setData("%ANSWERSHASH%", hash256);
            this.taskInfo.setData("%ANSWERSHASH_MD5%", HashHelper.hash(Helper.getAnswerFilesAsString(answersAsFiles), "MD5"));
            this.taskInfo.setData("%ANSWERSHASH_SHA-1%", HashHelper.hash(Helper.getAnswerFilesAsString(answersAsFiles), "SHA-1"));
            this.taskInfo.setData("%ANSWERSHASH_SHA-256%", HashHelper.hash(Helper.getAnswerFilesAsString(answersAsFiles), "SHA-256"));
        }
    }
}

