/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.defaulttools.operators.DefaultOperator;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.exceptions.FailedExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskRunner;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class OperatorTaskRunner
extends TaskRunner {
    public OperatorTaskRunner(TaskScheduler parent, Task task) {
        super(parent, task);
    }

    @Override
    protected boolean runSpecificRunner() throws CancelExecutionException {
        boolean success;
        File finalResultFile;
        block10: {
            if (this.task.getTool() instanceof DefaultOperator) {
                DefaultOperator defaultOperator = (DefaultOperator)this.task.getTool();
                try {
                    finalResultFile = defaultOperator.applyOperator((OperatorTask)this.task);
                    success = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                    boolean success2 = false;
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " execution failed!" + Log.getExceptionAppendix(e));
                }
            }
            if (!this.task.getTool().isExternal()) {
                try {
                    success = this.runInternal();
                    if (success) {
                        File resultWithAsteriskFile = new File(Helper.replaceVariables(this.task.getTool().getExecute().getResult(), this.task, this.task.getParent().getParent().getGlobalVariables()));
                        finalResultFile = FileHelper.waitForResult(resultWithAsteriskFile, this.task);
                        if (finalResultFile == null) {
                            throw new FileNotFoundException("Result file was not generated. Maybe " + Helper.getQualifiedName(this.task.getTool()) + " has not finished properly.\n(" + resultWithAsteriskFile.getAbsolutePath() + ")");
                        }
                        break block10;
                    }
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but did not finish successfully.");
                }
                catch (FileNotFoundException e) {
                    throw new CancelExecutionException(e.getMessage());
                }
            }
            success = this.runExternal();
            if (success) {
                finalResultFile = this.externalAnswerFile;
            } else {
                throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was externally executed but did not finish successfully.");
            }
        }
        this.task.getTaskAnswer().setAnswerFile(finalResultFile);
        Storage.getInstance().getData().store(this.task);
        return success;
    }

    @Override
    protected List<File> getExternalFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (Task child : this.task.getChildren()) {
            files.add(child.getTaskAnswer().getAnswerFile());
        }
        return files;
    }

    @Override
    protected String getExternalQuery() {
        OperatorQuestion query = (OperatorQuestion)Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this.task);
        StringBuilder sb = new StringBuilder(query.getOperator()).append(" [ ");
        for (int i = 0; i < this.task.getChildren().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("'%FILE_" + (i + 1) + "%' ?");
        }
        sb.append(" ] ").append(query.getEndingSymbol());
        return sb.toString();
    }
}

