/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.exceptions.FailedExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskRunner;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public class PreprocessorTaskRunner
extends TaskRunner {
    public PreprocessorTaskRunner(TaskScheduler parent, Task task) {
        super(parent, task);
    }

    @Override
    protected boolean runSpecificRunner() throws CancelExecutionException {
        File finalResultFile;
        boolean success;
        block7: {
            if (!this.task.getTool().isExternal()) {
                try {
                    success = this.runInternal();
                    if (success) {
                        File resultWithAsteriskFile = new File(Helper.replaceVariables(this.task.getTool().getExecute().getResult(), this.task, this.task.getParent().getParent().getGlobalVariables()));
                        finalResultFile = FileHelper.waitForResult(resultWithAsteriskFile, this.task);
                        if (finalResultFile == null) {
                            throw new FileNotFoundException("Result file was not generated. Maybe " + Helper.getQualifiedName(this.task.getTool()) + " has not finished properly.\n(" + resultWithAsteriskFile.getAbsolutePath() + ")");
                        }
                        break block7;
                    }
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but did not finish successfully.");
                }
                catch (FileNotFoundException e) {
                    throw new CancelExecutionException(e.getMessage());
                }
            }
            success = this.runExternal();
            if (success) {
                finalResultFile = this.externalAnswerFile;
            } else {
                throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was externally executed but did not finish successfully.");
            }
        }
        this.task.getTaskAnswer().setAnswerFile(finalResultFile);
        Storage.getInstance().getData().store(this.task);
        ((PreprocessorTask)this.task).updateQuestionReference();
        return success;
    }

    @Override
    protected List<File> getExternalFiles() {
        return Helper.getPreprocessorFiles(this.task);
    }

    @Override
    protected String getExternalQuery() {
        throw new UnsupportedOperationException("A preprocessor cannot be associated with a query.");
    }
}

