/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.OperatorQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskCreator;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.PlaceholderTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.RootTask;
import de.foellix.aql.system.task.TaskAnswer;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.gui.TaskTreeViewer;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class Task
implements Serializable {
    private static final long serialVersionUID = 4800793822439273893L;
    public static final int STATUS_APK_NOT_FOUND = -5;
    public static final int STATUS_NO_APPROPRIATE_TOOL = -4;
    public static final int STATUS_EXECUTION_INTERRUPTED = -3;
    public static final int STATUS_EXECUTION_TIMEOUT = -2;
    public static final int STATUS_EXECUTION_FAILED = -1;
    public static final int STATUS_EXECUTION_UNKNOWN = 0;
    public static final int STATUS_EXECUTION_SUCCESSFUL = 1;
    public static final String STATUS_TEXT_PLACEHODLER = "Incomplete/Placeholder";
    public static final String STATUS_TEXT_DONE = "Done";
    public static final String STATUS_TEXT_FAILED = "Failed";
    public static final String STATUS_TEXT_RUNNING = "Running";
    public static final String STATUS_TEXT_READY = "Ready";
    public static final String STATUS_TEXT_UNKNOWN = "Unknown";
    protected final transient TaskCreator parent;
    private TaskAnswer taskAnswer;
    private boolean updated;
    private Set<Task> parents;
    private Set<Task> children;
    protected transient Tool tool;
    protected final TaskInfo taskInfo;
    protected transient Set<Tool> toolsFailed;

    public Task(TaskCreator taskCreator, TaskInfo taskInfo, Tool tool) {
        this.parent = taskCreator;
        this.updated = false;
        this.parents = new HashSet<Task>();
        this.children = new LinkedHashSet<Task>();
        this.tool = tool;
        this.taskInfo = taskInfo;
    }

    public void update() {
        for (Task parent : new HashSet<Task>(this.parents)) {
            this.parent.tryPlaceholderReplacement(parent);
        }
        for (Task parent : this.parents) {
            if (parent instanceof PlaceholderTask) continue;
            parent.refreshVariables(this);
        }
        this.parent.checkTransformations(this);
        this.updated = true;
    }

    public abstract void refreshVariables(Task var1);

    public boolean isReady() {
        for (Task child : this.children) {
            if (child.isUpdated()) continue;
            return false;
        }
        for (Task child : this.children) {
            if (child.getTaskAnswer().isAnswered()) continue;
            return false;
        }
        return true;
    }

    private boolean isUpdated() {
        return this.updated;
    }

    public Set<Task> getChildren() {
        return this.getChildren(false);
    }

    public Set<Task> getChildren(boolean recursive) {
        if (!recursive) {
            return this.children;
        }
        LinkedHashSet<Task> temp = new LinkedHashSet<Task>();
        temp.addAll(this.children);
        for (Task child : this.children) {
            temp.addAll(child.getChildren(true));
        }
        return temp;
    }

    public int countAvailableAnswersOfChildren() {
        int counter = 0;
        for (Task task : this.children) {
            if (!task.getTaskAnswer().isAnswered()) continue;
            ++counter;
        }
        return counter;
    }

    public Set<Answer> getAvailableAnswersOfChildren() {
        LinkedHashSet<Answer> answers = new LinkedHashSet<Answer>();
        for (Task task : this.children) {
            Answer castedAnswer;
            if (task.getTaskAnswer().getType() == 0 && task.getTaskAnswer().isAnswered()) {
                answers.add((Answer)task.getTaskAnswer().getAnswer());
                continue;
            }
            if (task.getTaskAnswer().getType() != 1 || !task.getTaskAnswer().isAnswered() || (castedAnswer = AnswerHandler.castToAnswer(task.getTaskAnswer().getAnswerFile())) == null) continue;
            answers.add(castedAnswer);
        }
        return answers;
    }

    public Set<Task> getLeafs() {
        return this.getLeafs(false);
    }

    public Set<Task> getLeafs(boolean ignoreAnsweredChildren) {
        HashSet<Task> leafs = new HashSet<Task>();
        if ((this.children == null || this.children.isEmpty() || ignoreAnsweredChildren && this.isReady()) && (this instanceof RootTask || !ignoreAnsweredChildren || ignoreAnsweredChildren && !this.taskAnswer.isAnswered())) {
            leafs.add(this);
        } else {
            for (Task child : this.children) {
                leafs.addAll(child.getLeafs(ignoreAnsweredChildren));
            }
        }
        return leafs;
    }

    public void addChild(Task child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        if (!child.getParents().contains(this)) {
            child.addParent(this);
        }
    }

    public void removeChild(Task child) {
        this.children.remove(child);
        if (child.getParents().contains(this)) {
            child.removeParent(this);
        }
    }

    public Set<Task> getParents() {
        return this.parents;
    }

    public void addParent(Task parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
        if (!parent.getChildren().contains(this)) {
            parent.addChild(this);
        }
    }

    public void removeParent(Task parent) {
        this.parents.remove(parent);
        if (parent.getChildren().contains(this)) {
            parent.removeChild(this);
        }
    }

    public void replaceByTask(Task newTask) {
        HashSet<Task> parents = new HashSet<Task>(this.getParents());
        for (Task parent : parents) {
            if (!newTask.getParents().contains(parent)) {
                newTask.getParents().add(parent);
            }
            LinkedHashSet<Task> newChildren = new LinkedHashSet<Task>();
            for (Task child : parent.getChildren()) {
                if (child == this) {
                    newChildren.add(newTask);
                    continue;
                }
                newChildren.add(child);
            }
            parent.children = newChildren;
        }
        for (Task leaf : newTask.getLeafs()) {
            for (Task child : this.getChildren()) {
                leaf.addChild(child);
            }
        }
        for (Task parent : parents) {
            parent.removeChild(this);
        }
    }

    public String getHashableString() {
        if (this.isReady()) {
            if (this.tool != null) {
                return this.getRunCommand(true, false);
            }
        } else {
            Log.msg("Cannot generate hash for task since it is not in ready state.", 4);
        }
        return null;
    }

    public String getRunCommand() {
        return this.getRunCommand(false, true);
    }

    public String getRunCommand(boolean useHashes, boolean reportMissingVariables) {
        if (this.tool != null && this.tool.getExecute() != null) {
            if (!this.tool.isExternal()) {
                String runCmd;
                if (this.tool instanceof DefaultTool) {
                    StringBuilder sb = new StringBuilder(this.tool.getExecute().getRun() + " with { ");
                    Set<String> allVariables = this.taskInfo.getAllSetVariableNames();
                    boolean first = true;
                    for (String variable : allVariables) {
                        if (!first) {
                            sb.append(", ");
                        } else {
                            first = false;
                        }
                        sb.append(variable.replace("%", "#PERCENTAGE#") + " = '" + variable + "'");
                    }
                    sb.append(" }");
                    runCmd = Helper.replaceVariables(sb.toString(), this, this.parent.getParent().getGlobalVariables(), useHashes);
                    if (reportMissingVariables) {
                        Helper.reportMissingVariables(runCmd, this);
                    }
                    runCmd = runCmd.replace("#PERCENTAGE#", "%");
                } else {
                    runCmd = Helper.replaceVariables(this.tool.getExecute().getRun(), this, this.parent.getParent().getGlobalVariables(), useHashes);
                    if (reportMissingVariables) {
                        Helper.reportMissingVariables(runCmd, this);
                    }
                }
                return runCmd;
            }
            String questionReference = null;
            Question question = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this);
            if (question instanceof DefaultQuestion) {
                questionReference = Helper.typeToSoi(((DefaultQuestion)question).getSubjectOfInterest());
            } else if (question instanceof OperatorQuestion) {
                questionReference = ((OperatorQuestion)question).getOperator();
            }
            StringBuilder sb = new StringBuilder(Helper.getQualifiedName(this.tool) + ": " + (String)(questionReference != null ? questionReference + " " : "") + "@ " + this.tool.getExecute().getUrl() + " with { ");
            boolean first = true;
            for (String variable : this.taskInfo.getAllSetVariableNames()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(variable.replace("%", "#PERCENTAGE#") + " = '" + variable + "'");
            }
            sb.append(" }");
            if (!(this instanceof PreprocessorTask)) {
                sb.append(" and query: ").append(Helper.replaceDoubleSpaces(Helper.replaceAllWhiteSpaceChars(Helper.getExternalQuery(this), true)));
            }
            String runCmd = Helper.replaceVariables(sb.toString(), this, this.parent.getParent().getGlobalVariables(), useHashes);
            if (reportMissingVariables) {
                Helper.reportMissingVariables(runCmd, this);
            }
            runCmd = runCmd.replace("#PERCENTAGE#", "%");
            return runCmd;
        }
        return null;
    }

    public String getRunOnEntry() {
        return this.getRunOnEntry(false);
    }

    public String getRunOnEntry(boolean useHashes) {
        if (this.tool != null && this.tool.getRunOnEntry() != null) {
            return Helper.replaceVariables(this.tool.getRunOnEntry(), this, this.parent.getParent().getGlobalVariables(), useHashes);
        }
        return null;
    }

    public String getRunOnExit() {
        return this.getRunOnExit(false);
    }

    public String getRunOnExit(boolean useHashes) {
        if (this.tool != null && this.tool.getRunOnExit() != null) {
            return Helper.replaceVariables(this.tool.getRunOnExit(), this, this.parent.getParent().getGlobalVariables(), useHashes);
        }
        return null;
    }

    public String getRunOnSuccess() {
        return this.getRunOnSuccess(false);
    }

    public String getRunOnSuccess(boolean useHashes) {
        if (this.tool != null && this.tool.getRunOnSuccess() != null) {
            return Helper.replaceVariables(this.tool.getRunOnSuccess(), this, this.parent.getParent().getGlobalVariables(), useHashes);
        }
        return null;
    }

    public String getRunOnFail() {
        return this.getRunOnFail(false);
    }

    public String getRunOnFail(boolean useHashes) {
        if (this.tool != null && this.tool.getRunOnFail() != null) {
            return Helper.replaceVariables(this.tool.getRunOnFail(), this, this.parent.getParent().getGlobalVariables(), useHashes);
        }
        return null;
    }

    public String getRunOnAbort() {
        return this.getRunOnAbort(false);
    }

    public String getRunOnAbort(boolean useHashes) {
        if (this.tool != null && this.tool.getRunOnAbort() != null) {
            return Helper.replaceVariables(this.tool.getRunOnAbort(), this, this.parent.getParent().getGlobalVariables(), useHashes);
        }
        return null;
    }

    public File getRunInPath() {
        return this.getRunInPath(false);
    }

    public File getRunInPath(boolean useHashes) {
        if (this.tool != null && this.tool.getPath() != null) {
            return new File(Helper.replaceVariables(this.tool.getPath(), this, this.parent.getParent().getGlobalVariables(), useHashes));
        }
        return null;
    }

    public TaskCreator getParent() {
        return this.parent;
    }

    public Tool getTool() {
        return this.tool;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    public TaskAnswer getTaskAnswer() {
        return this.taskAnswer;
    }

    public void setTaskAnswer(TaskAnswer taskAnswer) {
        this.taskAnswer = taskAnswer;
    }

    public Set<Tool> getToolsFailed() {
        if (this.toolsFailed == null) {
            this.toolsFailed = new HashSet<Tool>();
        }
        return this.toolsFailed;
    }

    public Tool[] getToolsFailedAsArray() {
        return this.toolsFailed.toArray(new Tool[0]);
    }

    public String toString() {
        LinkedList<String> lines = new LinkedList<String>();
        this.toString(0, lines, false, null);
        StringBuilder sb = new StringBuilder("Execution Graph (W: waiting, R: ready, P: in progress, F: failed, D: done):\n");
        for (String line : lines) {
            sb.append(line).append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private String toString(int level, List<String> lines, boolean hasNextChild, String lastLine) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < level; ++i) {
            if (i == level - 1) {
                if (hasNextChild) {
                    sb.append("  |--");
                    continue;
                }
                sb.append("  \\--");
                continue;
            }
            sb.append("     ");
        }
        sb.append("- ").append(this.isReady() ? (this.getTaskAnswer().isAnswered() ? "D" : (!this.getToolsFailed().isEmpty() ? "F" : (this.parent.getParent().getTaskScheduler().inProgress(this) ? "P" : "R"))) : "W").append(": ").append((String)(this.tool != null ? this.tool.getName() + " (" + this.tool.getVersion() + ")" : (this instanceof RootTask ? "Root" : "Placeholder")));
        if (lastLine != null && lastLine.contains("|")) {
            for (i = 0; i < lastLine.length(); ++i) {
                char c = lastLine.charAt(i);
                if (c != '|') continue;
                sb.replace(i, i + 1, "|");
            }
        }
        lines.add(sb.toString());
        Iterator<Task> i2 = this.getChildren().iterator();
        while (i2.hasNext()) {
            Task child = i2.next();
            child.toString(level + 1, lines, i2.hasNext(), sb.toString());
        }
        return sb.toString();
    }

    public String getTitle() {
        if (this.getTool() != null) {
            return this.getTool().getName().replaceFirst(" for ", "\nfor ") + "\n(" + this.getTool().getVersion() + ")";
        }
        if (this instanceof RootTask) {
            return "Root";
        }
        if (this instanceof PlaceholderTask) {
            return "Placeholder";
        }
        return "Incomplete task (No tool assigned)";
    }

    public String getStatus() {
        if (this instanceof PlaceholderTask) {
            return STATUS_TEXT_PLACEHODLER;
        }
        if (this.getTaskAnswer().isAnswered()) {
            return STATUS_TEXT_DONE;
        }
        if (!this.getToolsFailed().isEmpty()) {
            return STATUS_TEXT_FAILED;
        }
        if (TaskTreeViewer.getTaskTreeSnapshot().getRunningTasks().contains(this)) {
            return STATUS_TEXT_RUNNING;
        }
        if (this.isReady()) {
            return STATUS_TEXT_READY;
        }
        return STATUS_TEXT_UNKNOWN;
    }
}

