/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.operators.DefaultFilterOperator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.RootTask;
import de.foellix.aql.system.task.RootTaskAnswer;
import de.foellix.aql.system.task.Task;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class TaskAnswer
implements Serializable {
    private static final long serialVersionUID = -2279233633809417421L;
    private static final DefaultFilterOperator soiFilter = new DefaultFilterOperator();
    private static final String FILE_ENDING_PLACEHOLDER = ".%FILE_ENDING%";
    public static final int ANSWER_TYPE_AQL = 0;
    public static final int ANSWER_TYPE_FILE = 1;
    public static final int ANSWER_TYPE_RAW = 2;
    protected Task parent;
    private File answerFile;
    private int type;
    private int subjectOfInterest;
    private boolean answered;

    public TaskAnswer(Task parent, int type) {
        this(parent, type, -1);
    }

    public TaskAnswer(Task parent, int type, int subjectOfInterest) {
        this.parent = parent;
        this.type = type;
        this.subjectOfInterest = subjectOfInterest;
        this.answered = false;
        if (parent instanceof RootTask) {
            this.answerFile = RootTaskAnswer.STATS_FILE;
        } else {
            this.answerFile = Storage.getInstance().getData().getNewAnswerFile();
            this.answerFile = new File(this.answerFile.getParentFile(), this.answerFile.getName() + this.getFileEnding());
        }
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public void setAnswerFile(File answerFile) {
        this.setAnswerFile(answerFile, false);
    }

    public void setAnswerFile(File answerFile, boolean doNotCopy) {
        if (!doNotCopy) {
            if (this.type == 1) {
                int i = answerFile.getName().lastIndexOf(46);
                this.answerFile = i > 0 ? new File(this.answerFile.getAbsolutePath().replace(FILE_ENDING_PLACEHOLDER, answerFile.getName().substring(i))) : new File(this.answerFile.getAbsolutePath().replace(FILE_ENDING_PLACEHOLDER, ""));
            }
            if (!answerFile.equals(this.answerFile)) {
                try {
                    Files.copy(answerFile.toPath(), this.answerFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Log.warning("Could not write answer to file storage: " + this.answerFile + Log.getExceptionAppendix(e));
                }
            }
        } else {
            this.answerFile = answerFile;
        }
        this.answered = true;
    }

    public File getAnswerFile() {
        return this.answerFile;
    }

    public Object getAnswer() {
        switch (this.type) {
            case 0: {
                Answer answer = AnswerHandler.parseXML(this.answerFile);
                if (this.subjectOfInterest != -1) {
                    answer = soiFilter.filterToSOI(answer, this.subjectOfInterest);
                }
                return answer;
            }
            case 1: {
                return this.answerFile;
            }
            case 2: {
                return this.getRawContent();
            }
        }
        return null;
    }

    public String getAnswerForQuery(boolean withQuotes) {
        if (withQuotes) {
            if (this.type == 2) {
                return "'" + this.getRawContent() + "'";
            }
            return "'" + this.answerFile.getAbsolutePath() + "'";
        }
        if (this.type == 2) {
            return this.getRawContent();
        }
        return this.answerFile.getAbsolutePath();
    }

    public String getRawContent() {
        try {
            return FileHelper.getRawContent(this.answerFile);
        }
        catch (IOException e) {
            Log.error("Cannot read raw data from answer file: " + this.answerFile.getAbsolutePath() + Log.getExceptionAppendix(e));
            this.parent.getParent().getParent().getTaskScheduler().taskFinished(this.parent, -1);
            return null;
        }
    }

    private String getFileEnding() {
        switch (this.type) {
            case 0: {
                return ".xml";
            }
            case 2: {
                return ".txt";
            }
            case 1: {
                return FILE_ENDING_PLACEHOLDER;
            }
        }
        return "";
    }

    public int getType() {
        return this.type;
    }

    public String typeToString() {
        switch (this.type) {
            case 1: {
                return "File";
            }
            case 2: {
                return "Raw";
            }
        }
        return "AQL";
    }

    public int getSubjectOfInterest() {
        return this.subjectOfInterest;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.typeToString()).append(": ");
        if (this.answered) {
            sb.append(this.answerFile.getAbsolutePath());
            sb.append(" (");
            String date = Helper.getDate(FileHelper.getFileProperties(this.answerFile).creationTime().toMillis(), "MM/dd/yyyy - HH:mm:ss");
            switch (this.type) {
                case 1: {
                    sb.append(date);
                }
                case 2: {
                    sb.append(this.getRawContent()).append(" - ").append(date);
                }
            }
            sb.append(Helper.typeToSoi(this.subjectOfInterest)).append(" - ").append(date);
            sb.append(")");
        } else {
            sb.append("Not answered!");
        }
        return sb.toString();
    }
}

