/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import com.google.common.io.Files;
import de.foellix.aql.Log;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.CLIHelper;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.ITaskHook;
import de.foellix.aql.system.ProcessWrapper;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.TaskTimer;
import de.foellix.aql.system.UnirestHandler;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.exceptions.FailedExecutionException;
import de.foellix.aql.system.exceptions.FeedbackAnswerException;
import de.foellix.aql.system.exceptions.TimeoutExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskAnswer;
import de.foellix.aql.system.task.ToolTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;

public abstract class TaskRunner
extends Thread {
    protected TaskScheduler parent;
    protected Task task;
    protected ProcessWrapper processWrapper;
    private TaskTimer timeoutTimer;
    protected File externalAnswerFile;

    public TaskRunner(TaskScheduler parent, Task task) {
        this.parent = parent;
        this.task = task;
        this.timeoutTimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean success = false;
        boolean canceled = false;
        boolean timedOut = false;
        String feedback = null;
        if (this.parent.getParent().getTaskHooksBefore().getHooks().get(this.task.getTool()) != null && !this.parent.getParent().getTaskHooksBefore().getHooks().get(this.task.getTool()).isEmpty()) {
            Log.msg("Running hooks before executing tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
            this.executeTaskHooks(true);
        }
        if (this.task.getRunOnEntry() != null) {
            Log.msg("Running on entry event for the tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
            if (!this.runExtraTask(this.task.getRunOnEntry())) {
                Log.warning("Execution of extra task on entry seemingly failed: " + this.task.getRunOnEntry());
            }
        }
        long timeout = this.parent.getParent().getOptions().getTimeout();
        if (this.task.getTool().getTimeout() != null) {
            long toolTimeout = CLIHelper.evaluateTimeout(this.task.getTool().getTimeout());
            if (this.parent.getParent().getOptions().getTimeoutMode() == 1) {
                timeout = Math.max(timeout, toolTimeout);
            } else if (this.parent.getParent().getOptions().getTimeoutMode() == 2) {
                timeout = Math.min(timeout, toolTimeout);
            }
        }
        if (timeout > 0L) {
            this.timeoutTimer = new TaskTimer(this, timeout);
            this.timeoutTimer.start();
        }
        try {
            this.runTool();
            success = true;
            if (this.task.getRunOnSuccess() != null) {
                Log.msg("Running on success event for the tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
                if (!this.runExtraTask(this.task.getRunOnSuccess())) {
                    Log.warning("Execution of extra task on success seemingly failed: " + this.task.getRunOnSuccess());
                }
            }
        }
        catch (FailedExecutionException e) {
            Log.error(Helper.getQualifiedName(this.task.getTool()) + " execution in \"" + this.task.getRunInPath().getAbsolutePath() + "\" failed:\n" + this.task.getRunCommand() + Log.getExceptionAppendix(e, true));
            if (this.task.getRunOnFail() != null) {
                Log.msg("Running on fail event for the tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
                if (!this.runExtraTask(this.task.getRunOnFail())) {
                    Log.warning("Execution of extra task on fail seemingly failed: " + this.task.getRunOnFail());
                }
            }
        }
        catch (TimeoutExecutionException e) {
            try {
                Log.error(Helper.getQualifiedName(this.task.getTool()) + " execution in \"" + this.task.getRunInPath().getAbsolutePath() + "\" timed out:\n" + this.task.getRunCommand() + Log.getExceptionAppendix(e, true));
            }
            catch (Exception newE) {
                Log.error("Tool execution timed out!" + Log.getExceptionAppendix(e));
            }
            timedOut = true;
        }
        catch (FeedbackAnswerException e) {
            try {
                Log.error(Helper.getQualifiedName(this.task.getTool()) + " execution in \"" + this.task.getRunInPath().getAbsolutePath() + "\" canceled:\n" + this.task.getRunCommand() + Log.getExceptionAppendix(e, true));
            }
            catch (Exception newE) {
                Log.error("Tool execution gave feedback answer!" + Log.getExceptionAppendix(e));
            }
            this.runOnAbort();
            feedback = e.getMessage();
        }
        catch (CancelExecutionException e) {
            try {
                Log.error(Helper.getQualifiedName(this.task.getTool()) + " execution in \"" + this.task.getRunInPath().getAbsolutePath() + "\" canceled:\n" + this.task.getRunCommand() + Log.getExceptionAppendix(e, true));
            }
            catch (Exception newE) {
                Log.error("Tool execution canceled!" + Log.getExceptionAppendix(e));
            }
            this.runOnAbort();
            canceled = true;
        }
        finally {
            if (this.isTimeoutTimerAlive()) {
                this.timeoutTimer.interrupt();
            }
        }
        if (this.task.getRunOnExit() != null) {
            Log.msg("Running on exit event for the tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
            if (!this.runExtraTask(this.task.getRunOnExit())) {
                Log.warning("Execution of extra task on exit seemingly failed: " + this.task.getRunOnExit());
            }
        }
        if (this.parent.getParent().getTaskHooksAfter().getHooks().get(this.task.getTool()) != null && !this.parent.getParent().getTaskHooksAfter().getHooks().get(this.task.getTool()).isEmpty()) {
            Log.msg("Running hooks after executing tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
            this.executeTaskHooks(false);
        }
        if (timedOut) {
            this.parent.taskFinished(this.task, -2);
        } else if (feedback != null) {
            this.parent.taskFinished(this.task, feedback);
        } else if (canceled) {
            this.parent.taskFinished(this.task, -3);
        } else if (success) {
            this.parent.taskFinished(this.task, 1);
        } else {
            this.parent.taskFinished(this.task, -1);
        }
    }

    public void runOnAbort() {
        if (this.task.getRunOnAbort() != null) {
            Log.msg("Running on abort event for the tool: " + Helper.getQualifiedName(this.task.getTool()), 6);
            if (!this.runExtraTask(this.task.getRunOnAbort())) {
                Log.warning("Execution of extra task on abort seemingly failed: " + this.task.getRunOnAbort());
            }
        }
    }

    private void runTool() throws CancelExecutionException {
        long time = System.currentTimeMillis();
        TaskAnswer taskAnswer = Storage.getInstance().getData().load(this.task);
        if (taskAnswer != null) {
            this.task.getTaskAnswer().setAnswerFile(taskAnswer.getAnswerFile(), true);
            Question loadedQuestion = null;
            if (this.task instanceof ToolTask) {
                for (Task parent : this.task.getParents()) {
                    if (parent instanceof ConverterTask && (loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(parent)) != null) break;
                }
            }
            if (this.task instanceof PreprocessorTask) {
                ((PreprocessorTask)this.task).updateQuestionReference();
                Log.msg("Loaded from storage: Preprocessor result for App('" + this.task.getTaskInfo().getData("%APP_APK%") + "' | '" + this.task.getTool().getQuestions() + "')", 0);
            } else {
                String loadedQuestionString;
                if (loadedQuestion == null) {
                    loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this.task);
                }
                Log.msg("Loaded from storage:" + ((loadedQuestionString = loadedQuestion.toString()).contains("\n") ? "\n" : " ") + loadedQuestionString, 0);
            }
            return;
        }
        Log.msg("Starting execution of " + (this.task.getTool() instanceof DefaultTool ? "default " : (this.task.getTool().isExternal() ? "external " : "internal ")) + Helper.getQualifiedName(this.task.getTool()) + "." + (String)(Log.logIt(5, true) ? " [" + this.task.getRunInPath().getAbsolutePath() + ": " + this.task.getRunCommand() + "]" : ""), 0);
        this.runSpecificRunner();
        Log.msg("Finished execution of " + (this.task.getTool() instanceof DefaultTool ? "default " : (this.task.getTool().isExternal() ? "external " : "internal ")) + Helper.getQualifiedName(this.task.getTool()) + " after " + (float)Math.round((System.currentTimeMillis() - time) / 10L) / 100.0f + " seconds." + (String)(Log.logIt(5) ? " [" + this.task.getRunInPath().getAbsolutePath() + ": " + this.task.getRunCommand() + "]" : ""), 0);
    }

    protected abstract boolean runSpecificRunner() throws CancelExecutionException;

    private boolean runExtraTask(String cmd) {
        try {
            Process process = new ProcessBuilder(Helper.getRunCommandAsArray(cmd)).directory(this.task.getRunInPath()).start();
            this.processWrapper = new ProcessWrapper(process);
            return this.processWrapper.waitFor() == 0;
        }
        catch (IOException e) {
            Log.warning("Extra task could not be executed: " + cmd + Log.getExceptionAppendix(e));
            return true;
        }
    }

    private void executeTaskHooks(boolean before) {
        List<ITaskHook> hooks = before ? this.parent.getParent().getTaskHooksBefore().getHooks().get(this.task.getTool()) : this.parent.getParent().getTaskHooksAfter().getHooks().get(this.task.getTool());
        if (hooks != null) {
            for (ITaskHook hook : hooks) {
                try {
                    hook.execute(this.task);
                }
                catch (Exception e) {
                    Log.warning("Something went wrong while executing hook " + (before ? "before " : "after ") + this.task.getTool().getName() + "(" + this.task.getTool().getVersion() + ") was executed." + Log.getExceptionAppendix(e));
                }
            }
        }
    }

    public boolean isTimeoutTimerAlive() {
        if (this.timeoutTimer == null) {
            return false;
        }
        return this.timeoutTimer.isAlive();
    }

    @Override
    public void interrupt() {
        if (this.processWrapper != null) {
            this.processWrapper.cancel();
        }
        super.interrupt();
    }

    protected boolean runInternal() throws CancelExecutionException {
        Process process;
        try {
            process = new ProcessBuilder(Helper.getRunCommandAsArray(this.task.getRunCommand())).directory(this.task.getRunInPath()).start();
        }
        catch (IOException e) {
            throw new CancelExecutionException("Internal tool \"" + this.task.getRunCommand() + "\" could not be executed in \"" + this.task.getRunInPath().getAbsolutePath() + "\"!" + Log.getExceptionAppendix(e));
        }
        long pid = Helper.getPid(process);
        this.task.getTaskInfo().setData("%PID%", String.valueOf(pid));
        this.processWrapper = new ProcessWrapper(this.task, process);
        int terminationSignal = this.processWrapper.waitFor();
        if (this.timeoutTimer != null && this.timeoutTimer.isTimedOut()) {
            Log.msg("Process " + pid + " timed out!", 6);
            throw new TimeoutExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but timed out.");
        }
        if (this.processWrapper.isCanceled()) {
            Log.msg("Process " + pid + " canceled!", 6);
            throw new CancelExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but canceled.");
        }
        Log.msg("Process " + pid + " terminated " + (String)(terminationSignal == 0 ? "sucessfully (0)" : "unsuccessfully (" + terminationSignal + ")"), 6);
        return terminationSignal == 0;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean runExternal() throws CancelExecutionException {
        try {
            UnirestHandler.getInstance().start(this.parent.getParent());
            request = Unirest.post((String)this.task.getTool().getExecute().getUrl());
            requestWithParameters = request.field("timeout", (Object)String.valueOf(this.parent.getTimeout()).toString()).field("username", this.task.getTool().getExecute().getUsername()).field("password", this.task.getTool().getExecute().getPassword()).field("files", this.getExternalFiles());
            if (!(this.task instanceof PreprocessorTask)) {
                requestWithParameters = requestWithParameters.field("query", this.getExternalQuery());
            }
            this.externalAnswerFile = FileHelper.getTempFile();
            success = true;
            if (this.task.getTaskAnswer().getType() == 1) {
                responseFile = requestWithParameters.asBytes();
                if (responseFile.getStatus() != 200) {
                    Log.msg("Request error code (1): " + responseFile.getStatus() + " (" + responseFile.getStatusText() + ")", 6);
                    success = false;
                }
                try {
                    Files.write((byte[])((byte[])responseFile.getBody()), (File)this.externalAnswerFile);
                    if (!FileHelper.isAPK(this.externalAnswerFile)) ** GOTO lbl38
                    externalAnswerApk = FileHelper.getTempFile(".apk");
                    Files.move((File)this.externalAnswerFile, (File)externalAnswerApk);
                    this.externalAnswerFile = externalAnswerApk;
                }
                catch (IOException e) {
                    throw new CancelExecutionException("Error while storing file answer (" + this.externalAnswerFile.getAbsolutePath() + "): " + e.getMessage());
                }
            } else {
                responseString = requestWithParameters.asString();
                if (responseString.getStatus() != 200) {
                    Log.msg("Request error code (2): " + responseString.getStatus() + " (" + responseString.getStatusText() + ")", 6);
                    success = false;
                }
                try {
                    writer = new FileWriter(this.externalAnswerFile);
                    try {
                        writer.append((CharSequence)responseString.getBody());
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new CancelExecutionException("Error while storing string answer (" + this.externalAnswerFile.getAbsolutePath() + "): " + e.getMessage());
                }
            }
            if (success && this.externalAnswerFile != null && this.externalAnswerFile.exists()) {
                feedback = Helper.getFeedbackFromFile(this.externalAnswerFile);
                if (feedback != null) {
                    throw new FeedbackAnswerException(feedback);
                }
                var5_10 = true;
                return var5_10;
            }
            var4_6 = false;
            return var4_6;
        }
        catch (UnirestException e) {
            throw new CancelExecutionException("Error occured while accessing external tool!" + Log.getExceptionAppendix(e));
        }
        finally {
            UnirestHandler.getInstance().stop();
        }
    }

    protected abstract List<File> getExternalFiles();

    protected abstract String getExternalQuery();

    public Task getTask() {
        return this.task;
    }
}

