/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.defaulttools.DefaultTool;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.RootTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.ui.gui.GUI;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;

public class TaskSummary {
    private String status;
    private String title;
    private String tool;
    private String failedTools;
    private String variables;
    private String execution;
    private String query;
    private String executionGraph;
    private String answer;

    public TaskSummary(Task task) {
        StringBuilder sb;
        boolean incomplete = false;
        try {
            this.status = "Status: " + task.getStatus();
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            this.title = task.getTitle().replace("\n", " ");
            if (this.title.equals("Root")) {
                this.title = task.getChildren().size() == 1 ? "Query" : "Queries";
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (task.getTool() != null) {
                this.tool = "Tool: " + task.getTool().getName() + " (" + task.getTool().getVersion() + ")";
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (!(task instanceof RootTask)) {
                sb = new StringBuilder("Failed Tools: ");
                if (task.getToolsFailed().isEmpty()) {
                    sb.append("-");
                } else {
                    boolean first = true;
                    for (Tool tool : task.getToolsFailed()) {
                        if (first) {
                            first = false;
                        } else {
                            sb.append(',');
                        }
                        sb.append(tool.getName() + " (" + tool.getVersion() + ")");
                    }
                }
                this.failedTools = sb.toString();
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (task.getTaskInfo() != null) {
                this.variables = task.getTaskInfo().toString();
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (task.getTool() != null && !(task.getTool() instanceof DefaultTool)) {
                sb = new StringBuilder();
                if (!task.getTool().isExternal()) {
                    sb.append("Run command: " + task.getTool().getExecute().getRun());
                    String runCmd = task.getRunCommand();
                    sb.append("\nRun command (variables resolved): " + runCmd);
                    String missingVars = Helper.reportMissingVariables(runCmd, task);
                    if (missingVars == null) {
                        missingVars = "-";
                    }
                    sb.append("\nMissing variables: " + missingVars);
                } else if (!(task instanceof PreprocessorTask)) {
                    sb.append("External query: " + Helper.getExternalQuery(task));
                    List<File> attachedFiles = Helper.getExternalAppFiles(task);
                    attachedFiles.addAll(Helper.getExternalQueryFiles(task));
                    Collections.sort(attachedFiles);
                    sb.append("\nAttached files: " + attachedFiles);
                } else {
                    sb.append("Preprocessor URL: " + task.getTool().getExecute().getUrl());
                    sb.append("\nAttached files: " + Helper.getPreprocessorFiles(task));
                }
                this.execution = sb.toString();
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true) != null) {
                String temp = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(task, true).toString();
                this.query = "Partial Query:" + (temp.contains("\n") ? "\n" : " ") + temp;
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            this.executionGraph = task.toString();
        }
        catch (Exception e) {
            incomplete = true;
        }
        try {
            if (task.getTaskAnswer() != null && task.getTaskAnswer().getAnswerFile() != null) {
                this.answer = "Answer file: " + task.getTaskAnswer().getAnswerFile().getAbsolutePath();
            }
        }
        catch (Exception e) {
            incomplete = true;
        }
        if (incomplete) {
            Log.msg("Task summary incomplete!\n" + this.getSummary(true), 6);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTool() {
        return this.tool;
    }

    public String getVariables() {
        return this.variables;
    }

    public String getExecution() {
        return this.execution;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAnswer() {
        return this.answer;
    }

    public String getSummary(boolean withTitle) {
        StringBuilder sb = new StringBuilder();
        if (withTitle) {
            sb.append("*** " + this.title + " ***\n");
        }
        sb.append("- " + this.status);
        sb.append("\n\n");
        if (this.tool != null) {
            sb.append("- " + this.tool);
            sb.append("\n\n");
        }
        if (this.failedTools != null) {
            sb.append("- " + this.failedTools);
            sb.append("\n\n");
        }
        if (this.variables != null) {
            sb.append("- " + this.variables);
            sb.append("\n\n");
        }
        if (this.execution != null) {
            sb.append("- " + this.execution.replace("\n", "\n\n- "));
            sb.append("\n\n");
        }
        if (this.query != null) {
            sb.append("- " + this.query);
            sb.append("\n\n");
        }
        if (this.executionGraph != null) {
            sb.append("- " + this.executionGraph.replace("\n", "\n\t"));
            sb.append("\n\n");
        }
        if (this.answer != null) {
            sb.append("- " + this.answer);
            sb.append("\n\n");
        }
        return sb.toString().substring(0, sb.toString().length() - 2);
    }

    public void showInfoDialog() {
        BorderPane pane = new BorderPane();
        pane.setPrefHeight(450.0);
        pane.setPrefWidth(650.0);
        pane.setPadding(new Insets(10.0));
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setText(this.getSummary(false));
        textArea.setFont(Font.font((String)"Consolas", (double)14.0));
        pane.setCenter((Node)textArea);
        GUI.alert(false, "Details", this.getTitle(), (Pane)pane);
    }
}

