/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.LoadingQuestion;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.datastructure.query.StringOrQuestionPair;
import de.foellix.aql.helper.AppInfo;
import de.foellix.aql.system.TaskCreator;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;

public class ToolTask
extends Task {
    private static final long serialVersionUID = -5789871100141384864L;

    public ToolTask(TaskCreator taskCreator, ToolTaskInfo taskInfo, Tool tool) {
        super(taskCreator, taskInfo, tool);
    }

    @Override
    public void refreshVariables(Task child) {
        Question needle;
        Question loadedFileQuestion;
        Question loadedQuestion;
        if (child instanceof PreprocessorTask && (loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true)) instanceof DefaultQuestion) {
            DefaultQuestion question = (DefaultQuestion)loadedQuestion;
            if (child instanceof PreprocessorTask) {
                AppInfo appInfo;
                File apkFile;
                PreprocessorTask loadedPreprocessorTask;
                if (question.getIn() != null && question.getIn().getExecutedPreprocessorKeywords() != null && !question.getIn().getExecutedPreprocessorKeywords().isEmpty()) {
                    for (String keyword : question.getIn().getExecutedPreprocessorKeywords()) {
                        loadedPreprocessorTask = Storage.getInstance().getData().getPreprocessorTask(question.getIn(), keyword);
                        if (child != loadedPreprocessorTask) continue;
                        apkFile = (File)child.getTaskAnswer().getAnswer();
                        appInfo = new AppInfo(apkFile);
                        this.taskInfo.setData("%APP_APK_IN%", appInfo.getApkFile().getAbsolutePath());
                        this.taskInfo.setData("%APP_APK_IN_FILENAME%", appInfo.getFilename());
                        this.taskInfo.setData("%APP_APK_IN_NAME%", appInfo.getAppName());
                        this.taskInfo.setData("%APP_APK_IN_PACKAGE%", appInfo.getPkgName());
                    }
                }
                if (question.getFrom() != null && question.getFrom().getExecutedPreprocessorKeywords() != null && !question.getFrom().getExecutedPreprocessorKeywords().isEmpty()) {
                    for (String keyword : question.getFrom().getExecutedPreprocessorKeywords()) {
                        loadedPreprocessorTask = Storage.getInstance().getData().getPreprocessorTask(question.getFrom(), keyword);
                        if (child != loadedPreprocessorTask) continue;
                        apkFile = (File)child.getTaskAnswer().getAnswer();
                        appInfo = new AppInfo(apkFile);
                        this.taskInfo.setData("%APP_APK_FROM%", appInfo.getApkFile().getAbsolutePath());
                        this.taskInfo.setData("%APP_APK_FROM_FILENAME%", appInfo.getFilename());
                        this.taskInfo.setData("%APP_APK_FROM_NAME%", appInfo.getAppName());
                        this.taskInfo.setData("%APP_APK_FROM_PACKAGE%", appInfo.getPkgName());
                    }
                }
                if (question.getTo() != null && question.getTo().getExecutedPreprocessorKeywords() != null && !question.getTo().getExecutedPreprocessorKeywords().isEmpty()) {
                    for (String keyword : question.getTo().getExecutedPreprocessorKeywords()) {
                        loadedPreprocessorTask = Storage.getInstance().getData().getPreprocessorTask(question.getTo(), keyword);
                        if (child != loadedPreprocessorTask) continue;
                        apkFile = (File)child.getTaskAnswer().getAnswer();
                        appInfo = new AppInfo(apkFile);
                        this.taskInfo.setData("%APP_APK_TO%", appInfo.getApkFile().getAbsolutePath());
                        this.taskInfo.setData("%APP_APK_TO_FILENAME%", appInfo.getFilename());
                        this.taskInfo.setData("%APP_APK_TO_NAME%", appInfo.getAppName());
                        this.taskInfo.setData("%APP_APK_TO_PACKAGE%", appInfo.getPkgName());
                    }
                }
            }
        }
        if (child.getTaskAnswer().getType() == 1) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof DefaultQuestion) {
                if (((DefaultQuestion)loadedQuestion).getIn() != null && ((DefaultQuestion)loadedQuestion).getIn().getApp() == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_IN%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_IN_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_IN_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_IN_PACKAGE%", appInfo.getPkgName());
                } else if (((DefaultQuestion)loadedQuestion).getFrom() != null && ((DefaultQuestion)loadedQuestion).getFrom().getApp() == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_FROM%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_FROM_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_FROM_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_FROM_PACKAGE%", appInfo.getPkgName());
                } else if (((DefaultQuestion)loadedQuestion).getTo() != null && ((DefaultQuestion)loadedQuestion).getTo().getApp() == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_TO%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_TO_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_TO_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_TO_PACKAGE%", appInfo.getPkgName());
                } else {
                    this.refreshWith(child, loadedQuestion, loadedFileQuestion);
                }
            }
        }
        if (child.getTaskAnswer().getType() == 0) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof DefaultQuestion) {
                this.refreshWith(child, loadedQuestion, loadedFileQuestion);
            }
        }
        if (child.getTaskAnswer().getType() == 2) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof DefaultQuestion) {
                this.refreshWith(child, loadedQuestion, loadedFileQuestion);
                if (((DefaultQuestion)loadedQuestion).getIn() != null) {
                    if (((DefaultQuestion)loadedQuestion).getIn().getStatement() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getIn().getStatement()) == loadedFileQuestion) {
                        this.taskInfo.setData("%STATEMENT_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getIn().getMethod() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getIn().getMethod()) == loadedFileQuestion) {
                        this.taskInfo.setData("%METHOD_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getIn().getClassname() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getIn().getClassname()) == loadedFileQuestion) {
                        this.taskInfo.setData("%CLASS_IN%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                }
                if (((DefaultQuestion)loadedQuestion).getFrom() != null) {
                    if (((DefaultQuestion)loadedQuestion).getFrom().getStatement() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getFrom().getStatement()) == loadedFileQuestion) {
                        this.taskInfo.setData("%STATEMENT_FROM%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getFrom().getMethod() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getFrom().getMethod()) == loadedFileQuestion) {
                        this.taskInfo.setData("%METHOD_FROM%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getFrom().getClassname() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getFrom().getClassname()) == loadedFileQuestion) {
                        this.taskInfo.setData("%CLASS_FROM%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                }
                if (((DefaultQuestion)loadedQuestion).getTo() != null) {
                    if (((DefaultQuestion)loadedQuestion).getTo().getStatement() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getTo().getStatement()) == loadedFileQuestion) {
                        this.taskInfo.setData("%STATEMENT_TO%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getTo().getMethod() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getTo().getMethod()) == loadedFileQuestion) {
                        this.taskInfo.setData("%METHOD_TO%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                    if (((DefaultQuestion)loadedQuestion).getTo().getClassname() instanceof Question && (needle = (Question)((DefaultQuestion)loadedQuestion).getTo().getClassname()) == loadedFileQuestion) {
                        this.taskInfo.setData("%CLASS_TO%", child.getTaskAnswer().getAnswerForQuery(false));
                    }
                }
            }
        }
        if (child.getTaskAnswer().getType() == 1) {
            loadedQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(this, true);
            loadedFileQuestion = Storage.getInstance().getData().getQuestionFromQuestionTaskMap(child);
            if (loadedQuestion instanceof DefaultQuestion && loadedFileQuestion instanceof LoadingQuestion) {
                AppInfo appInfo;
                File apkFile;
                this.refreshWith(child, loadedQuestion, loadedFileQuestion);
                if (((DefaultQuestion)loadedQuestion).getIn() != null && ((DefaultQuestion)loadedQuestion).getIn().getApp() instanceof LoadingQuestion && (needle = (Question)((DefaultQuestion)loadedQuestion).getIn().getApp()) == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_IN%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_IN_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_IN_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_IN_PACKAGE%", appInfo.getPkgName());
                }
                if (((DefaultQuestion)loadedQuestion).getFrom() != null && ((DefaultQuestion)loadedQuestion).getFrom().getApp() instanceof LoadingQuestion && (needle = (Question)((DefaultQuestion)loadedQuestion).getFrom().getApp()) == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_FROM%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_FROM_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_FROM_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_FROM_PACKAGE%", appInfo.getPkgName());
                }
                if (((DefaultQuestion)loadedQuestion).getTo() != null && ((DefaultQuestion)loadedQuestion).getTo().getApp() instanceof LoadingQuestion && (needle = (Question)((DefaultQuestion)loadedQuestion).getTo().getApp()) == loadedFileQuestion) {
                    apkFile = (File)child.getTaskAnswer().getAnswer();
                    appInfo = new AppInfo(apkFile);
                    this.taskInfo.setData("%APP_APK_TO%", appInfo.getApkFile().getAbsolutePath());
                    this.taskInfo.setData("%APP_APK_TO_FILENAME%", appInfo.getFilename());
                    this.taskInfo.setData("%APP_APK_TO_NAME%", appInfo.getAppName());
                    this.taskInfo.setData("%APP_APK_TO_PACKAGE%", appInfo.getPkgName());
                }
            }
        }
    }

    private void refreshWith(Task child, Question loadedQuestion, Question loadedFileQuestion) {
        if (((DefaultQuestion)loadedQuestion).getWiths() != null) {
            String answerFileString = child.getTaskAnswer().getAnswerForQuery(false);
            for (StringOrQuestionPair pair : ((DefaultQuestion)loadedQuestion).getWiths()) {
                if (pair.getValue() == loadedFileQuestion && pair.getKey().isComplete(true)) {
                    this.taskInfo.setData("%" + pair.getKey().toStringInAnswer(false) + "%", answerFileString);
                    break;
                }
                if (pair.getKey() != loadedFileQuestion || !pair.getValue().isComplete(true)) continue;
                this.taskInfo.setData("%" + answerFileString + "%", pair.getValue().toStringInAnswer(false));
                break;
            }
        }
    }
}

