/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.converter.DefaultConverter;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.TaskScheduler;
import de.foellix.aql.system.defaulttools.analysistools.DefaultAnalysisTool;
import de.foellix.aql.system.exceptions.CancelExecutionException;
import de.foellix.aql.system.exceptions.FailedExecutionException;
import de.foellix.aql.system.storage.Storage;
import de.foellix.aql.system.task.ConverterTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskRunner;
import de.foellix.aql.system.task.ToolTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ToolTaskRunner
extends TaskRunner {
    public ToolTaskRunner(TaskScheduler parent, Task task) {
        super(parent, task);
    }

    @Override
    protected boolean runSpecificRunner() throws CancelExecutionException {
        boolean success;
        File finalResultFile;
        block14: {
            if (this.task.getTool() instanceof DefaultAnalysisTool) {
                DefaultAnalysisTool defaultAnalysisTool = (DefaultAnalysisTool)this.task.getTool();
                try {
                    finalResultFile = defaultAnalysisTool.applyAnalysisTool((ToolTask)this.task);
                    success = true;
                }
                catch (Exception e) {
                    boolean success2 = false;
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " execution failed!" + Log.getExceptionAppendix(e));
                }
            }
            if (!this.task.getTool().isExternal()) {
                try {
                    success = this.runInternal();
                    if (success) {
                        ConverterTask converterParent;
                        File resultWithAsteriskFile = new File(Helper.replaceVariables(this.task.getTool().getExecute().getResult(), this.task, this.task.getParent().getParent().getGlobalVariables()));
                        finalResultFile = FileHelper.waitForResult(resultWithAsteriskFile, this.task);
                        if (finalResultFile == null && (converterParent = Helper.getConverterParent(this.task)) != null && converterParent.getTool() instanceof DefaultConverter) {
                            finalResultFile = ((DefaultConverter)converterParent.getTool()).getConverter().recoverResultFromOutput(this.processWrapper.getOutput(), resultWithAsteriskFile);
                        }
                        if (finalResultFile == null) {
                            throw new FileNotFoundException("Result file was not generated. Maybe " + Helper.getQualifiedName(this.task.getTool()) + " has not finished properly.\n(" + resultWithAsteriskFile.getAbsolutePath() + ")");
                        }
                        break block14;
                    }
                    throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was internally executed but did not finish successfully.");
                }
                catch (CancelExecutionException e) {
                    throw e;
                }
                catch (FileNotFoundException e) {
                    throw new CancelExecutionException(e.getMessage());
                }
            }
            success = this.runExternal();
            if (success) {
                finalResultFile = this.externalAnswerFile;
            } else {
                throw new FailedExecutionException(Helper.getQualifiedName(this.task.getTool()) + " was externally executed but did not finish successfully.");
            }
        }
        ConverterTask converterParent = Helper.getConverterParent(this.task);
        if (converterParent == null || this.task.getTool().isExternal()) {
            this.task.getTaskAnswer().setAnswerFile(finalResultFile, false);
            Storage.getInstance().getData().store(this.task);
        } else {
            this.task.getTaskAnswer().setAnswerFile(finalResultFile, true);
        }
        return success;
    }

    @Override
    protected List<File> getExternalFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : Helper.getExternalAppFiles(this.task)) {
            files.add(file);
        }
        for (File file : Helper.getExternalQueryFiles(this.task)) {
            files.add(file);
        }
        return new ArrayList<File>(files);
    }

    @Override
    protected String getExternalQuery() {
        String query = Helper.getExternalQuery(this.task);
        List<File> files = this.getExternalFiles();
        HashSet<File> alreadyReplaced = new HashSet<File>();
        int i = 0;
        for (File file : files) {
            if (alreadyReplaced.contains(file)) continue;
            alreadyReplaced.add(file);
            if (!query.contains(file.getAbsolutePath()) && !query.contains(file.getAbsolutePath().replace("\\", "/"))) {
                Log.warning("File not found in query (" + query + "): " + file.getAbsolutePath());
                continue;
            }
            query = query.replace(file.getAbsolutePath(), "%FILE_" + ++i + "%");
            query = query.replace(file.getAbsolutePath().replace("\\", "/"), "%FILE_" + i + "%");
        }
        query = Helper.replaceCustomVariables(query, this.parent.getParent().getGlobalVariables());
        Log.msg("External Query \"" + query + "\" with " + files + " constructed.", 6);
        return query;
    }
}

