/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task.gui;

import de.foellix.aql.system.task.PlaceholderTask;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.gui.TaskTreeViewer;
import de.foellix.jfx.graphs.Hasher;
import de.foellix.jfx.graphs.Node;
import de.foellix.jfx.graphs.Options;
import de.foellix.jfx.graphs.style.Style;
import de.foellix.jfx.graphs.style.StyleCondition;

public class AQLSkin
extends Options {
    public AQLSkin() {
        this.setPadding(10.0);
        this.setSameObjectEdgesEnabled(true);
        this.setHasher(new TaskHasher());
        this.addNodeStyle(new Style("nodePlaceholder", null, new StyleCondition(){

            public boolean fulfilled(Node node) {
                if (node.getButton() != null) {
                    node.getButton().getStyleClass().clear();
                }
                Task task = (Task)node.getObject();
                return task instanceof PlaceholderTask;
            }
        }));
        this.addNodeStyle(new Style("nodeDone", null, new StyleCondition(){

            public boolean fulfilled(Node node) {
                if (node.getButton() != null) {
                    node.getButton().getStyleClass().clear();
                }
                Task task = (Task)node.getObject();
                return task.getTaskAnswer().isAnswered();
            }
        }));
        this.addNodeStyle(new Style("nodeFailed", null, new StyleCondition(){

            public boolean fulfilled(Node node) {
                Task task;
                if (node.getButton() != null) {
                    node.getButton().getStyleClass().clear();
                }
                return !(task = (Task)node.getObject()).getToolsFailed().isEmpty();
            }
        }));
        this.addNodeStyle(new Style("nodeRunning", null, new StyleCondition(){

            public boolean fulfilled(Node node) {
                if (node.getButton() != null) {
                    node.getButton().getStyleClass().clear();
                }
                Task task = (Task)node.getObject();
                return TaskTreeViewer.getTaskTreeSnapshot().getRunningTasks().contains(task);
            }
        }));
        this.addNodeStyle(new Style("nodeReady", null, new StyleCondition(){

            public boolean fulfilled(Node node) {
                Task task;
                if (node.getButton() != null) {
                    node.getButton().getStyleClass().clear();
                }
                return (task = (Task)node.getObject()).getToolsFailed().isEmpty() && task.isReady();
            }
        }));
    }

    private class TaskHasher
    implements Hasher {
        private TaskHasher() {
        }

        public int hashCode(Object obj) {
            if (obj instanceof Task) {
                Task task = (Task)obj;
                int prime = 31;
                int result = 1;
                result = 31 * result + (task.getTaskInfo() == null ? 0 : task.getTaskInfo().toStringNoPID().hashCode());
                result = 31 * result + (task.getTool() == null ? 0 : task.getTool().hashCode());
                return result;
            }
            return -1;
        }
    }
}

