/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task.gui;

import de.foellix.aql.Log;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskSummary;
import de.foellix.aql.system.task.gui.AQLSkin;
import de.foellix.aql.system.task.gui.TaskTreeSnapshot;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.jfx.graphs.ActionHandler;
import de.foellix.jfx.graphs.Graph;
import de.foellix.jfx.graphs.GraphDrawer;
import de.foellix.jfx.graphs.Options;
import java.io.File;
import java.util.Set;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;

public class TaskTreeViewer
extends Application {
    private static final ActionHandler TASK_CLICK_HANDLER = new ActionHandler(){

        public void handle(Event e, GraphDrawer graphDrawer, de.foellix.jfx.graphs.Node node) {
            if (node.getObject() != null && node.getObject() instanceof Task) {
                Task task = (Task)node.getObject();
                TaskSummary summary = new TaskSummary(task);
                summary.showInfoDialog();
                Log.msg(summary.getSummary(true), 4);
            }
        }
    };
    private static final ActionHandler TASK_HOVER_HANDLER = new ActionHandler(){

        public void handle(Event e, GraphDrawer graphDrawer, de.foellix.jfx.graphs.Node node) {
            if (node.getObject() != null && node.getObject() instanceof Task) {
                Task task = (Task)node.getObject();
                TaskSummary summary = new TaskSummary(task);
                Tooltip tooltip = new Tooltip(summary.getSummary(true));
                tooltip.setMaxWidth(800.0);
                node.getButton().setTooltip(tooltip);
            }
        }
    };
    private static Pane pane;
    private static int counter;
    private static GraphDrawer drawer;
    private static long updating;
    private static Stage stage;
    private static TaskTreeSnapshot taskTreeSnapshot;

    public TaskTreeViewer() {
        pane = null;
        counter = -1;
        drawer = null;
        updating = 0L;
    }

    public void start(Stage stage) throws Exception {
        TaskTreeViewer.stage = stage;
        TaskTreeViewer.getPane();
        ScrollPane scrollPane = new ScrollPane((Node)pane);
        scrollPane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)scrollPane, 600.0, 800.0);
        scene.getStylesheets().add((Object)new File("data/gui/executionGraph.css").toURI().toString());
        stage.setTitle("AQL-System: Execution Monitor");
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        stage.setScene(scene);
        stage.show();
    }

    public static Stage getStage() {
        return stage;
    }

    public static Pane getPane() {
        if (pane == null) {
            pane = new Pane();
            pane.addEventFilter(ScrollEvent.ANY, e -> {
                if (e.isControlDown()) {
                    if (e.getDeltaY() < 0.0) {
                        if (pane.getScaleX() > 0.35) {
                            pane.setScaleX(pane.getScaleX() * 0.9);
                            pane.setScaleY(pane.getScaleY() * 0.9);
                        } else {
                            pane.setScaleX(1.0);
                            pane.setScaleY(1.0);
                        }
                    } else if (e.getDeltaY() > 0.0) {
                        if (pane.getScaleX() < 3.0) {
                            pane.setScaleX(pane.getScaleX() / 0.9);
                            pane.setScaleY(pane.getScaleY() / 0.9);
                        } else {
                            pane.setScaleX(1.0);
                            pane.setScaleY(1.0);
                        }
                    }
                }
            });
        }
        return pane;
    }

    public static TaskTreeSnapshot getTaskTreeSnapshot() {
        return taskTreeSnapshot;
    }

    public static void update(TaskTreeSnapshot taskTreeSnapshot) {
        TaskTreeViewer.update(taskTreeSnapshot.getRootTask(), taskTreeSnapshot.getRunningTasks());
    }

    public static void update(Task rootTask, Set<Task> runningTasks) {
        counter = 0;
        Graph g = new Graph();
        de.foellix.jfx.graphs.Node root = g.getRoot();
        if (rootTask.getChildren().size() == 1) {
            root.setValue("Query");
        } else {
            root.setValue("Queries");
        }
        root.setObject((Object)rootTask);
        TaskTreeViewer.appendChildren(root, rootTask);
        taskTreeSnapshot = new TaskTreeSnapshot(rootTask, runningTasks);
        if (GUI.started || stage != null && stage.isShowing()) {
            new Thread(() -> {
                long time;
                updating = time = System.currentTimeMillis() - (long)runningTasks.size();
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    return;
                }
                if (time == updating || updating == 0L) {
                    Platform.runLater(() -> {
                        if (drawer == null) {
                            drawer = new GraphDrawer(g, pane, (Options)new AQLSkin());
                        } else {
                            drawer.setGraph(g);
                            drawer.redraw();
                        }
                    });
                }
            }).start();
        }
    }

    public static String getNodeLabel(Task task) {
        return ++counter + ") " + task.getTitle();
    }

    private static void appendChildren(de.foellix.jfx.graphs.Node node, Task task) {
        node.setOnClickListener(TASK_CLICK_HANDLER);
        node.setOnHoverListener(TASK_HOVER_HANDLER);
        for (Task childTask : task.getChildren()) {
            de.foellix.jfx.graphs.Node childNode = node.appendChild(TaskTreeViewer.getNodeLabel(childTask), (Object)childTask);
            TaskTreeViewer.appendChildren(childNode, childTask);
        }
    }
}

