/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.transformations;

import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.transformations.QuestionTransformer;
import java.util.HashSet;
import java.util.Set;

public class QueryTransformer {
    public static boolean transform(Query query, Question question) {
        return QueryTransformer.transform(query, question, new HashSet<String>());
    }

    public static boolean transform(Query query, Question question, Set<String> transformed) {
        transformed.add(question.toString());
        Question newQuestion = null;
        Question tempQuestion = QueryTransformer.transformQuestion(query, question);
        while (tempQuestion != null) {
            newQuestion = tempQuestion;
            tempQuestion = QueryTransformer.transformQuestion(query, tempQuestion);
        }
        boolean changed = false;
        if (newQuestion != null) {
            for (Question leaf : newQuestion.getLeafs()) {
                if (transformed.contains(leaf.toString())) continue;
                QueryTransformer.transform(query, leaf, transformed);
            }
            if (question.getParent() != null && !transformed.contains(question.getParent().toString())) {
                QueryTransformer.transform(query, question.getParent(), transformed);
            }
            changed = true;
        } else {
            for (Question leaf : question.getLeafs()) {
                if (transformed.contains(leaf.toString()) || !QueryTransformer.transform(query, leaf, transformed)) continue;
                changed = true;
            }
        }
        return changed;
    }

    private static Question transformQuestion(Query query, Question question) {
        Question newQuestion;
        QuestionTransformer transformer = new QuestionTransformer(question);
        if (transformer.isApplicable() && (newQuestion = transformer.transform()) != question) {
            if (question.getParent() != null) {
                question.getParent().replaceChild(question, newQuestion);
            } else if (query.getQuestions().contains(question)) {
                query.getQuestions().remove(question);
                query.getQuestions().add(newQuestion);
            }
            return newQuestion;
        }
        return null;
    }
}

