/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.transformations;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.handler.QueryHandler;
import de.foellix.aql.datastructure.query.DefaultQuestion;
import de.foellix.aql.datastructure.query.IStringOrQuestion;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.datastructure.query.Question;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.transformations.Priority;
import de.foellix.aql.transformations.Rule;
import de.foellix.aql.transformations.RulesHandler;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuestionTransformer {
    private static final String REPLACE_QUERY = "%QUERY%";
    private static final String REPLACE_FEATURE = "%FEATURE_#%";
    private static final String REPLACE_FEATURES = "%FEATURES%";
    private Question question;
    private Rule rule;
    private List<String> features;
    private Map<Rule, String> ruleQueryMap = new HashMap<Rule, String>();

    public QuestionTransformer(Question question) {
        List<IStringOrQuestion> features;
        this.question = question;
        this.features = null;
        if (question instanceof DefaultQuestion && (features = ((DefaultQuestion)question).getFeatures()) != null) {
            this.features = new LinkedList<String>();
            for (IStringOrQuestion feature : features) {
                String featuresStr;
                if (!feature.isComplete(false) || (featuresStr = feature.toStringInAnswer(false)) == null) continue;
                if (featuresStr.contains(",")) {
                    for (String featureStr : featuresStr.replace(" ", "").split(",")) {
                        this.features.add(featureStr);
                    }
                    continue;
                }
                this.features.add(featuresStr);
            }
        }
        this.rule = this.getTransformationRule();
        String keep = this.ruleQueryMap.get(this.rule);
        this.ruleQueryMap.clear();
        this.ruleQueryMap.put(this.rule, keep);
    }

    public boolean isApplicable() {
        return this.rule != null;
    }

    public Question transform() {
        if (this.isApplicable()) {
            Question transformedQuestion = this.applyRule();
            transformedQuestion.setParent(this.question.getParent());
            return transformedQuestion;
        }
        return this.question;
    }

    private Question applyRule() {
        String query = this.getQueryString(this.rule);
        if (query != null) {
            Query tempQuery = QueryHandler.parseQuery(query, true);
            if (tempQuery != null) {
                if (this.rule != null) {
                    if (this.rule.getName() != null) {
                        Log.msg("Transformation-rule applied: " + this.rule.getName(), 6);
                    } else {
                        Log.msg("Transformation-rule with no name applied.", 6);
                    }
                }
                return tempQuery.getQuestions().iterator().next();
            }
            Log.msg("Rule (" + (this.rule.getName() != null ? this.rule.getName() : "no name given") + ") could not be applied on:\n" + this.question + "\nsince it let to an invalid query:\n" + Helper.autoformat(query).replace("\\\\", "\\"), 6);
        }
        return this.question;
    }

    private boolean isApplicable(Rule rule) {
        if (this.isSimpleRule(rule)) {
            return this.getRulePriority(rule) > 0 && this.isApplicableSimple(rule);
        }
        return this.getRulePriority(rule) > 0 && this.isApplicableInOut(rule);
    }

    private String getQueryString(Rule rule) {
        String query = this.ruleQueryMap.get(rule);
        if (query == null) {
            query = this.isSimpleRule(rule) ? this.getQueryStringSimple(rule) : this.getQueryStringInOut(rule);
            this.ruleQueryMap.put(rule, query);
        }
        return query;
    }

    private String cleanUpQuery(String query) {
        return Helper.replaceAllWhiteSpaceChars(query, true).replace(",,", ",").replace(", ,", ",");
    }

    private boolean isSimpleRule(Rule rule) {
        return rule.getQuery() != null;
    }

    private Rule getTransformationRule() {
        Rule ruleToApply = null;
        int highestPriority = 0;
        for (Rule rule : RulesHandler.getInstance().getRules()) {
            int prio;
            if (!this.isApplicable(rule) || (prio = this.getRulePriority(rule)) <= highestPriority) continue;
            ruleToApply = rule;
            highestPriority = prio;
        }
        return ruleToApply;
    }

    private int getRulePriority(Rule rule) {
        int value = 0;
        for (Priority prio : rule.getPriority()) {
            if (prio.getFeature() == null && prio.getValue() != null) {
                value += prio.getValue().intValue();
            }
            if (this.features == null || prio.getFeature() == null || prio.getValue() == null || !this.features.contains(prio.getFeature())) continue;
            value += prio.getValue().intValue();
        }
        return value;
    }

    private boolean isApplicableInOut(Rule rule) {
        return this.getQueryString(rule) != null;
    }

    private String getQueryStringInOut(Rule rule) {
        int i;
        String query = Helper.replaceAllWhiteSpaceChars(this.question.toString().replace("->", " -> "), true);
        String ruleInputQuery = Helper.replaceAllWhiteSpaceChars(rule.getInputQuery().replace("->", " -> "), true);
        String ruleOutputQuery = Helper.replaceAllWhiteSpaceChars(rule.getOutputQuery().replace("->", " -> "), true);
        LinkedList<String> placeHolderList = new LinkedList<String>();
        Pattern pattern = Pattern.compile("(\\*|%)([A-Za-z0-9_]+)(\\*|%)");
        Matcher matcher = pattern.matcher(ruleInputQuery);
        while (matcher.find()) {
            placeHolderList.add(matcher.group());
        }
        LinkedList<String> pieces = new LinkedList<String>();
        String temp = new String(ruleInputQuery);
        for (String pc : placeHolderList) {
            i = temp.indexOf(pc);
            pieces.add(temp.substring(0, i));
            temp = temp.substring(i + pc.length());
        }
        pieces.add(temp);
        Object constructedPattern = "";
        for (int i2 = 0; i2 < placeHolderList.size(); ++i2) {
            constructedPattern = (String)constructedPattern + this.preparePiece((String)pieces.get(i2)) + "(.*)";
        }
        constructedPattern = (String)constructedPattern + this.preparePiece((String)pieces.get(pieces.size() - 1));
        constructedPattern = ((String)constructedPattern).replace(" (.*) ", "(.*) ");
        pattern = Pattern.compile((String)constructedPattern);
        matcher = pattern.matcher(query);
        LinkedList<String> replacements = new LinkedList<String>();
        if (matcher.find()) {
            for (i = 1; i <= matcher.groupCount(); ++i) {
                replacements.add(matcher.group(i));
            }
        }
        if (placeHolderList.size() == replacements.size()) {
            String finalQuery = new String(ruleOutputQuery);
            for (int i3 = 0; i3 < placeHolderList.size(); ++i3) {
                String pc = (String)placeHolderList.get(i3);
                String replacement = (String)replacements.get(i3);
                finalQuery = finalQuery.replace(pc, replacement);
            }
            if (QueryHandler.parseQuery(finalQuery = this.cleanUpQuery(finalQuery), true) != null) {
                return finalQuery;
            }
        }
        return null;
    }

    private String preparePiece(String piece) {
        return piece.replace("(", "\\(").replace(")", "\\)").replace("?", "\\?").replace(".", "\\.").replace("$", "\\$");
    }

    private boolean isApplicableSimple(Rule rule) {
        return this.getQueryString(rule) != null && !this.getQueryString(rule).contains(REPLACE_QUERY) && !this.getQueryString(rule).contains("%FEATURE_") && !this.getQueryString(rule).contains(REPLACE_FEATURES) && !this.getQueryString(rule).contains("%APP_APK_IN%") && !this.getQueryString(rule).contains("%CLASS_IN%") && !this.getQueryString(rule).contains("%METHOD_IN%") && !this.getQueryString(rule).contains("%STATEMENT_IN%") && !this.getQueryString(rule).contains("%APP_APK_FROM%") && !this.getQueryString(rule).contains("%CLASS_FROM%") && !this.getQueryString(rule).contains("%METHOD_FROM%") && !this.getQueryString(rule).contains("%STATEMENT_FROM%") && !this.getQueryString(rule).contains("%APP_APK_TO%") && !this.getQueryString(rule).contains("%CLASS_TO%") && !this.getQueryString(rule).contains("%METHOD_TO%") && !this.getQueryString(rule).contains("%STATEMENT_TO%");
    }

    private String getQueryStringSimple(Rule rule) {
        if (this.question instanceof DefaultQuestion) {
            File apk;
            Reference ref;
            DefaultQuestion castedQuestion = (DefaultQuestion)this.question;
            HashMap<String, String> customVariables = new HashMap<String, String>();
            String replacement = castedQuestion.toString();
            if (replacement.endsWith("?")) {
                replacement = replacement.substring(0, replacement.lastIndexOf("?"));
                while (replacement.endsWith(" ")) {
                    replacement = replacement.substring(0, replacement.length() - 1);
                }
            }
            replacement = replacement.replace("\\", "\\\\");
            customVariables.put(REPLACE_QUERY, replacement);
            if (castedQuestion.getIn() != null && castedQuestion.getIn().isComplete(true)) {
                ref = castedQuestion.getIn().toReference();
                if (ref.getApp() != null && ref.getApp().getFile() != null && !ref.getApp().getFile().isEmpty()) {
                    apk = new File(ref.getApp().getFile());
                    customVariables.put("%APP_APK_IN%", apk.getAbsolutePath());
                }
                if (ref.getClassname() != null && !ref.getClassname().isEmpty()) {
                    customVariables.put("%CLASS_IN%", ref.getClassname());
                }
                if (ref.getMethod() != null && !ref.getMethod().isEmpty()) {
                    customVariables.put("%METHOD_IN%", ref.getMethod());
                }
                if (ref.getStatement() != null) {
                    if (ref.getStatement().getStatementfull() != null && !ref.getStatement().getStatementfull().isEmpty()) {
                        customVariables.put("%STATEMENT_IN%", ref.getStatement().getStatementfull());
                    } else if (ref.getStatement().getStatementgeneric() != null && !ref.getStatement().getStatementgeneric().isEmpty()) {
                        customVariables.put("%STATEMENT_IN%", ref.getStatement().getStatementgeneric());
                    }
                    customVariables.put("%LINENUMBER_IN%", String.valueOf(Helper.getLineNumberSafe(ref.getStatement())));
                }
            }
            if (castedQuestion.getFrom() != null && castedQuestion.getFrom().isComplete(true)) {
                ref = castedQuestion.getFrom().toReference();
                if (ref.getApp() != null && ref.getApp().getFile() != null && !ref.getApp().getFile().isEmpty()) {
                    apk = new File(ref.getApp().getFile());
                    customVariables.put("%APP_APK_FROM%", apk.getAbsolutePath());
                }
                if (ref.getClassname() != null && !ref.getClassname().isEmpty()) {
                    customVariables.put("%CLASS_FROM%", ref.getClassname());
                }
                if (ref.getMethod() != null && !ref.getMethod().isEmpty()) {
                    customVariables.put("%METHOD_FROM%", ref.getMethod());
                }
                if (ref.getStatement() != null) {
                    if (ref.getStatement().getStatementfull() != null && !ref.getStatement().getStatementfull().isEmpty()) {
                        customVariables.put("%STATEMENT_FROM%", ref.getStatement().getStatementfull());
                    } else if (ref.getStatement().getStatementgeneric() != null && !ref.getStatement().getStatementgeneric().isEmpty()) {
                        customVariables.put("%STATEMENT_FROM%", ref.getStatement().getStatementgeneric());
                    }
                    customVariables.put("%LINENUMBER_FROM%", String.valueOf(Helper.getLineNumberSafe(ref.getStatement())));
                }
            }
            if (castedQuestion.getTo() != null && castedQuestion.getTo().isComplete(true)) {
                ref = castedQuestion.getTo().toReference();
                if (ref.getApp() != null && ref.getApp().getFile() != null && !ref.getApp().getFile().isEmpty()) {
                    apk = new File(ref.getApp().getFile());
                    customVariables.put("%APP_APK_TO%", apk.getAbsolutePath());
                }
                if (ref.getClassname() != null && !ref.getClassname().isEmpty()) {
                    customVariables.put("%CLASS_TO%", ref.getClassname());
                }
                if (ref.getMethod() != null && !ref.getMethod().isEmpty()) {
                    customVariables.put("%METHOD_TO%", ref.getMethod());
                }
                if (ref.getStatement() != null) {
                    if (ref.getStatement().getStatementfull() != null && !ref.getStatement().getStatementfull().isEmpty()) {
                        customVariables.put("%STATEMENT_TO%", ref.getStatement().getStatementfull());
                    } else if (ref.getStatement().getStatementgeneric() != null && !ref.getStatement().getStatementgeneric().isEmpty()) {
                        customVariables.put("%STATEMENT_TO%", ref.getStatement().getStatementgeneric());
                    }
                    customVariables.put("%LINENUMBER_TO%", String.valueOf(Helper.getLineNumberSafe(ref.getStatement())));
                }
            }
            Object allFeatures = "";
            if (this.features != null) {
                for (int i = 0; i < this.features.size(); ++i) {
                    customVariables.put(REPLACE_FEATURE.replace("#", Integer.valueOf(i + 1).toString()), "'" + this.features.get(i) + "'");
                    allFeatures = (String)allFeatures + (((String)allFeatures).equals("") ? "'" : ", '") + this.features.get(i) + "'";
                }
            }
            customVariables.put(REPLACE_FEATURES, (String)allFeatures);
            return this.cleanUpQuery(Helper.replaceCustomVariables(rule.getQuery(), customVariables));
        }
        return null;
    }
}

