/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.transformations;

import de.foellix.aql.Log;
import de.foellix.aql.transformations.Rule;
import de.foellix.aql.transformations.Rules;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class RulesHandler {
    public static final File DEFAULT_RULES_FILE = new File("rules.xml");
    private List<File> rulesFiles;
    private Rules rules;
    private static RulesHandler instance = new RulesHandler();

    private RulesHandler() {
        this.setRulesFile(DEFAULT_RULES_FILE);
    }

    public static RulesHandler getInstance() {
        return instance;
    }

    public void setRulesFiles(List<File> rulesFiles) {
        this.rulesFiles = rulesFiles;
        this.init();
    }

    public void setRulesFile(File rulesFile) {
        if (this.rulesFiles == null) {
            this.rulesFiles = new ArrayList<File>();
        } else {
            this.rulesFiles.clear();
        }
        this.rulesFiles.add(rulesFile);
        this.init();
    }

    private void init() {
        this.rules = null;
        for (File rulesFile : this.rulesFiles) {
            if (rulesFile.exists()) {
                try {
                    FileReader reader = new FileReader(rulesFile);
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Rules.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    Rules rulesTemp = (Rules)jaxbUnmarshaller.unmarshal((Reader)reader);
                    if (this.rules == null) {
                        this.rules = rulesTemp;
                    } else {
                        this.rules.getRule().addAll(rulesTemp.getRule());
                    }
                    ((Reader)reader).close();
                }
                catch (IOException | JAXBException e) {
                    Log.error("Cannot parse rules (XML-)file. It must be corrupted!" + Log.getExceptionAppendix(e));
                }
                continue;
            }
            if (this.rules != null) continue;
            this.rules = new Rules();
        }
    }

    public List<Rule> getRules() {
        return this.rules.getRule();
    }

    public List<File> getRulesFiles() {
        return this.rulesFiles;
    }
}

