/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.cli;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.system.IAnswerAvailable;
import java.io.File;

public class AnswerToConsole
implements IAnswerAvailable {
    @Override
    public void answerAvailable(Object answer, int status) {
        if (status >= 0) {
            if (answer instanceof Answer) {
                int permissions;
                int intentsources;
                int intentsinks;
                int intents;
                int intentfilters;
                int sinks;
                int sources;
                int flows;
                Answer castedAnswer = (Answer)answer;
                try {
                    flows = castedAnswer.getFlows().getFlow().size();
                }
                catch (Exception e) {
                    flows = 0;
                }
                try {
                    sources = castedAnswer.getSources().getSource().size();
                }
                catch (Exception e) {
                    sources = 0;
                }
                try {
                    sinks = castedAnswer.getSinks().getSink().size();
                }
                catch (Exception e) {
                    sinks = 0;
                }
                try {
                    intentfilters = castedAnswer.getIntentfilters().getIntentfilter().size();
                }
                catch (Exception e) {
                    intentfilters = 0;
                }
                try {
                    intents = castedAnswer.getIntents().getIntent().size();
                }
                catch (Exception e) {
                    intents = 0;
                }
                try {
                    intentsinks = castedAnswer.getIntentsinks().getIntentsink().size();
                }
                catch (Exception e) {
                    intentsinks = 0;
                }
                try {
                    intentsources = castedAnswer.getIntentsources().getIntentsource().size();
                }
                catch (Exception e) {
                    intentsources = 0;
                }
                try {
                    permissions = castedAnswer.getPermissions().getPermission().size();
                }
                catch (Exception e) {
                    permissions = 0;
                }
                if (flows + sources + sinks + intentfilters + intents + intentsinks + intentsources + permissions == 0 || !Log.getShorten() && flows + sources + sinks + intentfilters + intents + intentsinks + intentsources + permissions < 100) {
                    Log.msg("\n\n\n" + AnswerHandler.createXMLString(castedAnswer) + "\n\n\n", 4);
                } else {
                    Log.msg("\nAQL-Answer:\n<answer>\n\t...\nShortened for the sake of clarity (Just showing numbers)\n\tFlows:" + flows + "\n\tSources:" + sources + "\n\tSinks:" + sinks + "\n\tIntentFilters:" + intentfilters + "\n\tIntents:" + intents + "\n\tIntentSinks:" + intentsinks + "\n\tIntentSources:" + intentsources + "\n\tPermissions:" + permissions + "\n\t...\n</answer>\n", 4);
                }
            } else if (answer instanceof File) {
                File castedAnswer = (File)answer;
                Log.msg("\nFile-Answer: " + castedAnswer.getAbsolutePath() + "\n", 4);
            } else if (answer instanceof String) {
                String castedAnswer = (String)answer;
                Log.msg("\nRaw-Answer: " + castedAnswer + "\n", 4);
            }
        }
    }
}

