/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.cli;

import de.foellix.aql.Log;
import de.foellix.aql.LogSilencer;
import de.foellix.aql.Properties;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.helper.CLIHelper;
import de.foellix.aql.helper.ManpageReader;
import de.foellix.aql.system.AQLSystem;
import de.foellix.aql.system.BackupAndReset;
import de.foellix.aql.system.Options;
import de.foellix.aql.ui.cli.OutputWriter;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.StartViewer;
import java.io.File;
import javafx.application.Application;
import javafx.application.Platform;
import org.fusesource.jansi.Ansi;
import org.slf4j.LoggerFactory;

public class CommandLineInterface {
    private static String output = null;
    private static String query = null;
    private static boolean gui = false;

    public static void main(String[] args) {
        try (LogSilencer s = new LogSilencer();){
            LoggerFactory.getLogger(CommandLineInterface.class);
        }
        String authorStr = "Author: " + Properties.info().AUTHOR + " (" + Properties.info().AUTHOR_EMAIL + ")";
        String space = "                 ".substring(Math.min(Properties.info().VERSION.length() + 3, 17));
        String centerspace = "                               ".substring(Math.min(32, authorStr.length() / 2));
        Log.msg(Ansi.ansi().bold().fg(Ansi.Color.GREEN).a("           ____  _          _____           _" + space).reset().a("v. " + Properties.info().VERSION).bold().fg(Ansi.Color.GREEN).a("\r\n     /\\   / __ \\| |        / ____|         | |                \r\n    /  \\ | |  | | |  _____| (___  _   _ ___| |_ ___ _ __ ___  \r\n   / /\\ \\| |  | | | |______\\___ \\| | | / __| __/ _ \\ '_ ` _ \\ \r\n  / ____ \\ |__| | |____    ____) | |_| \\__ \\ ||  __/ | | | | |\r\n /_/    \\_\\___\\_\\______|  |_____/ \\__, |___/\\__\\___|_| |_| |_|\r\n                                   __/ |                      \r\n                                  |___/                       \r\n").reset().a("\r\n" + centerspace + authorStr + "\r\n\r\n"), 4);
        CLIHelper.checkResources();
        if (args == null) {
            CommandLineInterface.help();
            return;
        }
        for (String arg : args) {
            if (!arg.equals("-help") && !arg.equals("-h") && !arg.equals("-?") && !arg.equals("-man") && !arg.equals("-manpage")) continue;
            CommandLineInterface.help();
            return;
        }
        Options options = new Options();
        boolean firstConfig = true;
        if (args == null || args.length == 0) {
            gui = true;
        } else {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-backup") && !args[i].equals("-b")) continue;
                BackupAndReset.backup();
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-gui")) {
                    gui = true;
                    continue;
                }
                if (args[i].equals("-ns") || args[i].equals("-noSplash")) {
                    options.setNoSplashScreen(true);
                    continue;
                }
                if (args[i].equals("-nr") || args[i].equals("-noRetry")) {
                    options.setRetry(false);
                    continue;
                }
                if (args[i].equals("-cw") || args[i].equals("-configwizard")) {
                    gui = true;
                    options.setShowConfigWizard(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("-view")) {
                    options.setViewAnswer(true);
                    continue;
                }
                if (args[i].equals("-dg") || args[i].equals("-draw") || args[i].equals("-drawGraph")) {
                    options.setDrawGraphs(true);
                    continue;
                }
                if (args[i].equals("-backup") || args[i].equals("-b")) continue;
                if (args[i].equals("-reset") || args[i].equals("-re") || args[i].equals("-r")) {
                    BackupAndReset.reset();
                    if (args.length <= i + 1 || !args[i + 1].equals("output") && !args[i + 1].equals("temp") && !args[i + 1].equals("answers")) continue;
                    BackupAndReset.resetOutputDirectories();
                    ++i;
                    continue;
                }
                if (args[i].equals("-c") || args[i].equals("-cfg") || args[i].equals("-config")) {
                    if (firstConfig) {
                        CLIHelper.evaluateConfig(args[i + 1]);
                        firstConfig = false;
                    } else {
                        File oldConfig = ConfigHandler.getInstance().getConfigFile();
                        CLIHelper.evaluateConfig(args[i + 1]);
                        ConfigHandler.getInstance().mergeWith(oldConfig);
                    }
                } else if (args[i].equals("-o") || args[i].equals("-out") || args[i].equals("-output")) {
                    output = args[i + 1];
                } else if (args[i].equals("-q") || args[i].equals("-query")) {
                    query = args[i + 1];
                } else if (args[i].equals("-rules")) {
                    CLIHelper.evaluateRules(args[i + 1]);
                } else if (args[i].equals("-d") || args[i].equals("-debug")) {
                    Log.setLogLevel(CLIHelper.evaluateLogLevel(args[i + 1], false));
                } else if (args[i].equals("-df") || args[i].equals("-dtf") || args[i].equals("-debugToFile")) {
                    Log.setLogToFileLevel(CLIHelper.evaluateLogLevel(args[i + 1], false));
                } else if (args[i].equals("-t") || args[i].equals("-timeout")) {
                    int mode;
                    options.setTimeout(CLIHelper.evaluateTimeout(args[i + 1]));
                    if (args.length > i + 2 && (mode = CLIHelper.evaluateTimeoutMode(args[i + 2])) != -1) {
                        options.setTimeoutMode(mode);
                        ++i;
                    }
                } else {
                    Log.error("Unknown launch parameter (" + args[i] + "). Canceling execution!");
                    System.exit(0);
                }
                ++i;
            }
        }
        if (!gui) {
            Log.disableGUIlogging();
            AQLSystem aqlSystem = new AQLSystem(options);
            if (output != null) {
                aqlSystem.getAnswerReceivers().add(new OutputWriter(new File(output)));
            }
            if (!options.getDrawGraphs() && options.getViewAnswer()) {
                aqlSystem.getAnswerReceivers().add(new StartViewer(args, options));
            }
            if (query != null) {
                if (options.getDrawGraphs() && options.getViewAnswer()) {
                    CommandLineInterface.startGUI(options, args, true);
                } else {
                    aqlSystem.query(query);
                }
            } else {
                Log.error("Please specify a query (e.g. -q \"Flows IN App('path/to/file.apk') ?\")");
            }
        } else {
            CommandLineInterface.startGUI(options, args, false);
        }
    }

    private static void startGUI(Options options, String[] args, final boolean runQueryImmediately) {
        GUI.options = options;
        if (query != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        while (!GUI.started || GUI.editor == null || !GUI.editor.isReady()) {
                            1.sleep(100L);
                        }
                        Platform.runLater(() -> GUI.editor.setContent(query));
                        if (runQueryImmediately) {
                            while (GUI.editor == null || GUI.editor.getContent() == null || GUI.editor.getContent().isEmpty()) {
                                1.sleep(100L);
                            }
                            GUI.ask();
                        }
                    }
                    catch (InterruptedException e) {
                        Log.error("Execution was interrupted when waiting for GUI to start.");
                    }
                }
            }.start();
        }
        if (!Log.logIt(6)) {
            Log.setSilence(true);
        }
        Application.launch(GUI.class, (String[])args);
    }

    private static void help() {
        Log.msg(ManpageReader.getInstance().getManpageContent(), 4);
    }
}

