/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.handler.QueryHandler;
import de.foellix.aql.datastructure.query.Query;
import de.foellix.aql.helper.EqualSymbolsComparator;
import de.foellix.aql.helper.GUIHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.LevenshteinComparator;
import de.foellix.aql.system.task.gui.TaskTreeViewer;
import de.foellix.aql.transformations.QueryTransformer;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.LogViewer;
import de.foellix.aql.ui.gui.MenubarEditor;
import de.foellix.aql.ui.gui.SearchAndReplaceBox;
import de.foellix.aql.ui.gui.Storage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.fxmisc.flowless.ScaledVirtualized;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.StyledDocument;

public class Editor
extends BorderPane {
    public static final double ZOOM_FACTOR = 0.9;
    public static final double ZOOM_LOWER_BOUND = 0.7;
    public static final double ZOOM_UPPER_BOUND = 6.0;
    private GUI parent;
    private boolean ready = false;
    private boolean stop;
    private FileChooser openDialog;
    private File currentDir;
    private CodeArea codeArea;
    private ScaledVirtualized<CodeArea> codeZoomPane;
    private StackPane codePane;
    private Popup popup;
    private ListView<AutoCompletionEntry> popupList;
    private int[] popupPart = new int[2];
    private boolean popupReady = true;
    private int popupCounter = 0;
    private int lastCaretPos = -1;
    private boolean topSelected;
    private static final String[] KEYWORDS1 = new String[]{"IN", "FROM", "TO", "FEATURES", "FEATURING", "USES", "USING", "WITH"};
    private static final String[] KEYWORDS3 = new String[]{"Arguments", "Flows", "IntentFilters", "Intents", "IntentSinks", "IntentSources", "Permissions", "Sinks", "Slice", "Sources", "Statement", "Class", "Method", "App"};
    private static final String[] AUTOCOMPLETION_START_SYMBOLS = new String[]{" ", "\t", "\n", "'", "(", "[", "{", "-", ">", ",", ".", "!", "?"};
    private static final String[] AUTOCOMPLETION_END_SYMBOLS = new String[]{" ", "\t", "\n", "'", ")", "]", "}", ".", "!", "?"};
    private static final String SUBJECT_OF_INTEREST = "Subject of interest";
    private static final String FOLLOWING_REFERENCE = "following reference";
    private static final String PART_OF_A_REFERENCE = "part of a Reference";
    private static AutoCompletionEntry[] AUTOCOMPLETION_KEYWORDS = null;
    private static AutoCompletionEntry AUTOCOMPLETION_INSERT_FILE = null;
    private static AutoCompletionEntry AUTOCOMPLETION_ENDING_SYMBOL_AQL = null;
    private static AutoCompletionEntry AUTOCOMPLETION_ENDING_SYMBOL_FILE = null;
    private static AutoCompletionEntry AUTOCOMPLETION_ENDING_SYMBOL_RAW = null;
    private static List<String> AUTOCOMPLETION_LAST_INSERTED_FILES = new LinkedList<String>();
    private static final String KEYWORD1_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS1) + ")\\b";
    private static final String KEYWORD2_PATTERN = "([A-Za-z0-9~]+ *\\[)";
    private static final String KEYWORD3_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS3) + ")\\b";
    private static final String PAREN1_PATTERN = "\\(|\\)";
    private static final String PAREN2_PATTERN = "\\[|\\]";
    private static final String PAREN3_PATTERN = "\\{|\\}";
    private static final String QUESTION_PATTERN = "\\?|\\!|\\.";
    private static final String ARROW_PATTERN = "\\->";
    private static final String COMMA_PATTERN = "\\,|\\||=";
    private static final String STRING_PATTERN = "'([^'\\\\]|\\\\.)*'";
    private static final String VAR1_PATTERN = "([A-Za-z0-9]+ *=)";
    private static final String VAR2_PATTERN = "\\$([^ \\)\\]]*)";
    private static final Pattern PATTERN = Pattern.compile("(?<KEYWORD1>" + KEYWORD1_PATTERN + ")|(?<KEYWORD2>([A-Za-z0-9~]+ *\\[))|(?<KEYWORD3>" + KEYWORD3_PATTERN + ")|(?<PAREN1>\\(|\\))|(?<PAREN2>\\[|\\])|(?<PAREN3>\\{|\\})|(?<QUESTION>\\?|\\!|\\.)|(?<ARROW>\\->)|(?<COMMA>\\,|\\||=)|(?<STRING>'([^'\\\\]|\\\\.)*')|(?<VAR1>([A-Za-z0-9]+ *=))|(?<VAR2>\\$([^ \\)\\]]*))");
    private MenubarEditor menuBar;

    public Editor() {
    }

    public Editor(GUI parent) {
        this();
        this.init(parent);
    }

    public void init(GUI parent) {
        this.parent = parent;
        if (AUTOCOMPLETION_KEYWORDS == null) {
            AUTOCOMPLETION_KEYWORDS = new AutoCompletionEntry[]{new AutoCompletionEntry("CONNECT", "connects the given answers", " [  ] ?"), new AutoCompletionEntry("FILTER", "filter the given answer", " [  ] ?"), new AutoCompletionEntry("INTERSECT", "intersects the given answers", " [  ] ?"), new AutoCompletionEntry("MINUS", "answer 1 without answer 2", " [  ] ?"), new AutoCompletionEntry("UNIFY", "unifies the given answers", " [  ] ?"), new AutoCompletionEntry("SIGN", "signs the given APK file", " [  ] !"), new AutoCompletionEntry("TOAD", "transforms Sources&Sinks to Amandroid's format", " [  ] !"), new AutoCompletionEntry("TOFD", "transforms Sources&Sinks to FlowDroid's format", " [  ] !"), new AutoCompletionEntry("Arguments", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Flows", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("IntentFilters", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Intents", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("IntentSinks", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("IntentSources", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Permissions", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Sinks", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Slice", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Sources", SUBJECT_OF_INTEREST, " "), new AutoCompletionEntry("Statement", "Optional part of a Reference", "('')"), new AutoCompletionEntry("Class", "Optional part of a Reference", "('')"), new AutoCompletionEntry("Method", "Optional part of a Reference", "('')"), new AutoCompletionEntry("App", "Mandatory part of a Reference", "('')"), new AutoCompletionEntry("IN", "in the following reference", " "), new AutoCompletionEntry("FROM", "from the following reference", " "), new AutoCompletionEntry("TO", "to the following reference", " "), new AutoCompletionEntry("FEATURES", "to attach features", " ''"), new AutoCompletionEntry("FEATURING", "to attach features - same as FEATURES", " ''"), new AutoCompletionEntry("USES", "force using a certain tool", " ''"), new AutoCompletionEntry("USING", "force using a certain tool - same as USES", " ''"), new AutoCompletionEntry("WITH", "to assign variables", " 'VARIABLE' = ")};
            AUTOCOMPLETION_INSERT_FILE = new AutoCompletionEntry("Insert path to file", "Opens file browser..", null);
            AUTOCOMPLETION_ENDING_SYMBOL_AQL = new AutoCompletionEntry("?", "Expect AQL-Answer ending symbol", null);
            AUTOCOMPLETION_ENDING_SYMBOL_FILE = new AutoCompletionEntry("!", "Expect File ending symbol", null);
            AUTOCOMPLETION_ENDING_SYMBOL_RAW = new AutoCompletionEntry(".", "Expect RAW data ending symbol", null);
            for (File file : Storage.getInstance().getRecentFiles(2)) {
                AUTOCOMPLETION_LAST_INSERTED_FILES.add(file.getAbsolutePath());
            }
        }
        this.openDialog = new FileChooser();
        this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"})});
        this.codeArea = new CodeArea();
        this.codeArea.setWrapText(true);
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeArea));
        this.codeArea.setStyle("-fx-font-family: Consolas;");
        this.codeArea.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY || event.getButton() == MouseButton.SECONDARY) {
                    Editor.this.popup.hide();
                }
            }
        });
        this.codeArea.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Bounds bounds = Editor.this.codeArea.localToScene(Editor.this.codeArea.getBoundsInLocal());
                if (event.getSceneX() < bounds.getMinX() || event.getSceneX() > bounds.getMinX() + bounds.getWidth() - 5.0 || event.getSceneY() < bounds.getMinY() || event.getSceneY() > bounds.getMinY() + bounds.getHeight() - 5.0) {
                    Editor.this.popup.hide();
                }
            }
        });
        GUIHelper.addFinder(this.codeArea, new SearchAndReplaceBox(this.codeArea, "Editor"));
        this.codeZoomPane = new ScaledVirtualized((Node)this.codeArea);
        this.codePane = new StackPane(new Node[]{new VirtualizedScrollPane(this.codeZoomPane)});
        this.codePane.setPrefWidth(2.147483647E9);
        this.popup = new Popup();
        this.popup.setAutoHide(true);
        this.popupList = new ListView();
        this.popupList.setPrefSize(350.0, 200.0);
        this.popupList.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() >= 2) {
                this.doAutoCompletion();
            }
        });
        this.popupList.setOnKeyPressed(e -> {
            KeyCode key = e.getCode();
            if (key == KeyCode.ENTER) {
                this.doAutoCompletion();
            } else if (key != KeyCode.UP && key != KeyCode.DOWN) {
                this.popup.hide();
                if (key == KeyCode.LEFT) {
                    if (this.codeArea.getCaretPosition() > 0) {
                        this.codeArea.moveTo(this.codeArea.getCaretPosition() - 1);
                    }
                } else if (key == KeyCode.RIGHT && this.codeArea.getCaretPosition() < this.codeArea.getText().length()) {
                    this.codeArea.moveTo(this.codeArea.getCaretPosition() + 1);
                }
            } else if (key == KeyCode.UP) {
                if (this.topSelected) {
                    this.popupList.getSelectionModel().clearSelection();
                } else if (this.popupList.getSelectionModel().getSelectedIndex() == 0) {
                    this.topSelected = true;
                }
            } else if (key == KeyCode.DOWN && this.popupList.getSelectionModel().getSelectedIndex() > 0) {
                this.topSelected = false;
            }
        });
        this.popup.getContent().add(this.popupList);
        this.codeArea.richChanges().filter(ch -> !((StyledDocument)ch.getInserted()).equals(ch.getRemoved())).subscribe(change -> this.codeArea.setStyleSpans(0, Editor.computeHighlighting(this.codeArea.getText())));
        this.codeArea.addEventFilter(ScrollEvent.ANY, e -> {
            if (e.isControlDown()) {
                if (e.getDeltaY() > 0.0) {
                    this.zoomIn();
                } else if (e.getDeltaY() < 0.0) {
                    this.zoomOut();
                }
            }
        });
        this.codeArea.setOnKeyPressed(event -> {
            ++this.popupCounter;
            int localCounter = this.popupCounter;
            if (this.popupReady && !this.popup.isShowing()) {
                new Thread(() -> {
                    try {
                        Thread.sleep(1500L);
                        if (this.popupCounter == localCounter) {
                            Platform.runLater(() -> {
                                if (this.codeArea.isFocused() && !this.popup.isShowing()) {
                                    this.autocomplete(false);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
        });
        this.menuBar = new MenubarEditor(this);
        parent.getSystem().getProgressListener().add(this.menuBar);
        this.setTop((Node)this.menuBar);
        this.setBottom((Node)new LogViewer());
        BorderPane egBox = new BorderPane();
        SplitPane splitPane = new SplitPane(new Node[]{this.codePane, egBox});
        ScrollPane graphPane = new ScrollPane((Node)TaskTreeViewer.getPane());
        graphPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        Button hideButton = new Button("\uf04e");
        FontAwesome.applyFontAwesome((Control)hideButton);
        hideButton.setMinWidth(50.0);
        hideButton.setOnAction(event -> {
            if (graphPane.isVisible()) {
                this.hideExecutionGraphs(graphPane, hideButton, splitPane);
            } else {
                this.showExecutionGraphs(graphPane, hideButton, splitPane, true);
            }
        });
        egBox.setCenter((Node)graphPane);
        egBox.setBottom((Node)hideButton);
        this.setCenter((Node)splitPane);
        if (this.parent.getSystem().getOptions().getDrawGraphs()) {
            this.showExecutionGraphs(graphPane, hideButton, splitPane, true);
        } else {
            this.hideExecutionGraphs(graphPane, hideButton, splitPane);
        }
        ((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty().addListener((obj, oldValue, newValue) -> {
            if ((double)(1.0f - newValue.floatValue()) > 60.0 / splitPane.getWidth() && newValue.intValue() != 1) {
                this.showExecutionGraphs(graphPane, hideButton, splitPane, false);
            } else {
                this.hideExecutionGraphs(graphPane, hideButton, splitPane);
            }
        });
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    private void showExecutionGraphs(ScrollPane pane, Button hideButton, SplitPane splitPane, boolean changeDividerPosition) {
        if (changeDividerPosition) {
            splitPane.setDividerPosition(0, 0.6);
        }
        pane.setMaxWidth(Double.MAX_VALUE);
        pane.setVisible(true);
        hideButton.setMaxWidth(Double.MAX_VALUE);
        hideButton.setText("\uf04e");
        this.parent.getSystem().getOptions().setDrawGraphs(true);
    }

    private void hideExecutionGraphs(ScrollPane pane, Button hideButton, SplitPane splitPane) {
        pane.setMaxWidth(50.0);
        pane.setVisible(false);
        hideButton.setMaxWidth(50.0);
        hideButton.setText("\uf04a");
        splitPane.setDividerPosition(0, 1.0);
        this.parent.getSystem().getOptions().setDrawGraphs(false);
    }

    private static StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD1") != null ? "keyword1" : (matcher.group("KEYWORD2") != null ? "keyword2" : (matcher.group("KEYWORD3") != null ? "keyword3" : (matcher.group("PAREN1") != null ? "paren1" : (matcher.group("PAREN2") != null ? "paren2" : (matcher.group("PAREN3") != null ? "paren3" : (matcher.group("QUESTION") != null ? "question" : (matcher.group("ARROW") != null ? "arrow" : (matcher.group("VAR1") != null ? "var" : (matcher.group("VAR2") != null ? "var" : (matcher.group("COMMA") != null ? "comma" : (styleClass = matcher.group("STRING") != null ? "string" : null)))))))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }

    public void zoomReset() {
        this.codeZoomPane.getZoom().setX(1.0);
        this.codeZoomPane.getZoom().setY(1.0);
    }

    public void zoomIn() {
        if (this.codeZoomPane.getZoom().getX() < 6.0) {
            this.codeZoomPane.getZoom().setX(this.codeZoomPane.getZoom().getX() / 0.9);
            this.codeZoomPane.getZoom().setY(this.codeZoomPane.getZoom().getY() / 0.9);
        }
    }

    public void zoomOut() {
        if (this.codeZoomPane.getZoom().getX() > 0.7) {
            this.codeZoomPane.getZoom().setX(this.codeZoomPane.getZoom().getX() * 0.9);
            this.codeZoomPane.getZoom().setY(this.codeZoomPane.getZoom().getY() * 0.9);
        }
    }

    public void autoformat() {
        Platform.runLater(() -> {
            this.popupReady = false;
            String content = this.codeArea.getText();
            content = Helper.autoformat(content);
            this.codeArea.replaceText(content);
            this.popupReady = true;
        });
    }

    public void ask() {
        if (!this.stop) {
            this.parent.getSystem().query(this.codeArea.getText());
        } else {
            this.parent.getSystem().queryCanceled(-3, "User canceled query execution!");
        }
    }

    public void setContent(String content) {
        Platform.runLater(() -> this.codeArea.replaceText(content));
        this.autoformat();
    }

    public void openFile(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(file.toPath());
        this.setContent(new String(encoded, StandardCharsets.UTF_8));
    }

    public GUI getParentGUI() {
        return this.parent;
    }

    public String getContent() {
        return this.codeArea.getText();
    }

    public void resetContent() {
        Platform.runLater(() -> this.codeArea.clear());
    }

    public void insertFilename() {
        Platform.runLater(() -> {
            String filename = "";
            if (this.currentDir != null) {
                this.openDialog.setInitialDirectory(this.currentDir);
            } else {
                this.openDialog.setInitialDirectory(new File("."));
            }
            File file = this.openDialog.showOpenDialog((Window)this.getParentGUI().getStage());
            if (file != null) {
                try {
                    filename = file.getAbsolutePath();
                    this.currentDir = file.getParentFile();
                    this.insert(filename);
                }
                catch (Exception e) {
                    Log.msg("File not found: " + file.toString(), 1);
                }
            }
        });
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public void insert(String string) {
        String before;
        int caret;
        if (!AUTOCOMPLETION_LAST_INSERTED_FILES.contains(string)) {
            AUTOCOMPLETION_LAST_INSERTED_FILES.add(0, string);
            Storage.getInstance().store(new File(string), 2);
        }
        String after = (caret = this.codeArea.getCaretPosition()) >= (before = this.codeArea.getText()).length() ? before.substring(0) + string : before.substring(0, caret) + string + before.substring(caret);
        this.codeArea.replaceText(after);
        this.codeArea.requestFocus();
        this.codeArea.moveTo(caret + string.length());
        this.popupReady = true;
    }

    public void transform() {
        Query queryObj = QueryHandler.parseQuery(this.codeArea.getText());
        if (QueryTransformer.transform(queryObj, queryObj.getQuestions().iterator().next())) {
            this.codeArea.replaceText(queryObj.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void autocomplete(boolean force) {
        try {
            boolean lookForFile;
            String wordBefore;
            String key;
            if (!force && this.codeArea.getText().isBlank()) {
                return;
            }
            int currentCaretPos = this.codeArea.getCaretPosition();
            if (!force && this.lastCaretPos == currentCaretPos) {
                return;
            }
            this.lastCaretPos = currentCaretPos;
            if (!force && this.codeArea.getCaretPosition() > 0 && ((key = this.codeArea.getText().substring(this.codeArea.getCaretPosition() - 1, this.codeArea.getCaretPosition())).equals("?") || key.equals("!") || key.equals("."))) {
                return;
            }
            int caret = this.codeArea.getCaretPosition();
            int from = 0;
            for (String symbol : AUTOCOMPLETION_START_SYMBOLS) {
                int newFrom = this.codeArea.getText().substring(0, caret).lastIndexOf(symbol);
                if (newFrom + 1 <= from) continue;
                from = 1 + newFrom;
            }
            String afterCaret = this.codeArea.getText().substring(caret);
            int to = Integer.MAX_VALUE;
            for (String string : AUTOCOMPLETION_END_SYMBOLS) {
                if (to <= afterCaret.indexOf(string) || !afterCaret.contains(string)) continue;
                to = this.codeArea.getText().substring(caret).indexOf(string);
            }
            to = to == Integer.MAX_VALUE ? caret : (to += caret);
            String key2 = this.codeArea.getText().substring(from, to);
            this.popupPart[0] = from;
            this.popupPart[1] = to;
            try {
                int fromBefore = 0;
                for (String symbol : AUTOCOMPLETION_START_SYMBOLS) {
                    int newFrom = this.codeArea.getText().substring(0, from - 1).lastIndexOf(symbol);
                    if (newFrom + 1 <= fromBefore) continue;
                    fromBefore = 1 + newFrom;
                }
                wordBefore = this.codeArea.getText().substring(fromBefore, from - 1);
            }
            catch (StringIndexOutOfBoundsException e) {
                wordBefore = null;
            }
            String key22 = this.getAutoCompletionEntryDescription(wordBefore);
            String string = " ";
            boolean offerQueryEnd = false;
            try {
                lookForFile = from > 0 && to > 0 && "'".equals(String.valueOf(this.codeArea.getText().charAt(from))) && "'".equals(String.valueOf(this.codeArea.getText().charAt(to)));
            }
            catch (IndexOutOfBoundsException e) {
                lookForFile = false;
            }
            if (from - 2 >= 0 && this.codeArea.getText().substring(from - 2, from).equals("->")) {
                key2 = "App";
            } else if (key22 != null) {
                if (key22.contains(SUBJECT_OF_INTEREST)) {
                    key2 = "IN following reference";
                    Object var10_21 = null;
                } else if (key22.contains(FOLLOWING_REFERENCE)) {
                    key2 = "App part of a Reference";
                    Object var10_22 = null;
                }
            } else if (key2.isBlank() && !lookForFile) {
                key2 = "Flows Subject of interest";
                Object var10_23 = null;
            } else if (key2.equalsIgnoreCase("apk") || key2.equals(")")) {
                offerQueryEnd = true;
            }
            this.popup.show((Node)this.codeArea, ((Bounds)this.codeArea.getCaretBounds().get()).getMaxX(), ((Bounds)this.codeArea.getCaretBounds().get()).getMaxY());
            this.popupList.getItems().clear();
            LinkedList<Object> items1 = new LinkedList<Object>();
            if (!lookForFile) {
                for (AutoCompletionEntry item : AUTOCOMPLETION_KEYWORDS) {
                    items1.add(item);
                }
            }
            items1.add(AUTOCOMPLETION_INSERT_FILE);
            if (offerQueryEnd) {
                this.popupList.getItems().addAll((Object[])new AutoCompletionEntry[]{AUTOCOMPLETION_ENDING_SYMBOL_AQL, AUTOCOMPLETION_ENDING_SYMBOL_FILE, AUTOCOMPLETION_ENDING_SYMBOL_RAW});
            }
            if (lookForFile) {
                this.popupList.getItems().addAll(items1);
            } else {
                void var10_24;
                LinkedList<Object> items2 = new LinkedList<Object>(items1);
                items1.sort(new EqualSymbolsComparator(key2, (String)var10_24));
                items2.sort(new LevenshteinComparator(((AutoCompletionEntry)items1.get(0)).toString()));
                items2.remove(items1.get(0));
                if (key2.length() <= 2) {
                    items2.remove(items1.get(1));
                    items2.remove(items1.get(2));
                }
                this.popupList.getItems().add((Object)((AutoCompletionEntry)items1.get(0)));
                if (key2.length() <= 2) {
                    this.popupList.getItems().add((Object)((AutoCompletionEntry)items1.get(1)));
                    this.popupList.getItems().add((Object)((AutoCompletionEntry)items1.get(2)));
                }
                this.popupList.getItems().addAll(items2);
            }
            for (String file : AUTOCOMPLETION_LAST_INSERTED_FILES) {
                this.popupList.getItems().add((Object)new AutoCompletionEntry(file, "lately inserted file", ""));
            }
            this.popupList.getSelectionModel().select(0);
            this.topSelected = true;
            this.popupList.requestFocus();
        }
        catch (Exception e) {
            Log.msg("Something went wrong during auto-completion." + Log.getExceptionAppendix(e), 6);
        }
    }

    private void doAutoCompletion() {
        if (!this.popupList.getSelectionModel().isEmpty()) {
            Object replacement;
            this.popupReady = false;
            AutoCompletionEntry entry = (AutoCompletionEntry)this.popupList.getSelectionModel().getSelectedItem();
            if (entry == AUTOCOMPLETION_ENDING_SYMBOL_AQL || entry == AUTOCOMPLETION_ENDING_SYMBOL_FILE || entry == AUTOCOMPLETION_ENDING_SYMBOL_RAW) {
                this.popupPart[0] = this.codeArea.getText().indexOf("\n", this.codeArea.getCaretPosition());
                if (this.popupPart[0] < 0) {
                    this.popupPart[0] = this.codeArea.getText().length();
                }
                if (this.codeArea.getText().charAt(this.popupPart[0] - 1) == '\n') {
                    this.popupPart[0] = this.popupPart[0] - 1;
                }
                this.popupPart[1] = this.popupPart[0];
                replacement = this.popupPart[0] - 1 > 0 && this.codeArea.getText().charAt(this.popupPart[0] - 1) == ' ' ? entry.getKeyword() : " " + entry.getKeyword();
            } else {
                replacement = entry.getOutput();
                if (AUTOCOMPLETION_LAST_INSERTED_FILES.contains(replacement)) {
                    AUTOCOMPLETION_LAST_INSERTED_FILES.remove(replacement);
                    AUTOCOMPLETION_LAST_INSERTED_FILES.add(0, (String)replacement);
                    Storage.getInstance().store(new File((String)replacement), 2);
                }
            }
            if (replacement == null) {
                this.insertFilename();
            } else {
                String before = this.codeArea.getText().substring(0, this.popupPart[0]);
                String after = this.codeArea.getText().substring(this.popupPart[1]);
                this.codeArea.replaceText(before + (String)replacement + after);
                this.codeArea.requestFocus();
                this.codeArea.moveTo(this.popupPart[0] + ((String)replacement).length() - ((AutoCompletionEntry)this.popupList.getSelectionModel().getSelectedItem()).getOffset());
                this.popupReady = true;
            }
        }
        this.popup.hide();
    }

    private String getAutoCompletionEntryDescription(String key) {
        if (key != null) {
            for (AutoCompletionEntry entry : AUTOCOMPLETION_KEYWORDS) {
                if (!entry.getKeyword().equalsIgnoreCase(key)) continue;
                return entry.toString();
            }
        }
        return null;
    }

    private class AutoCompletionEntry {
        private String keyword;
        private String description;
        private String output;
        private int offset;

        public AutoCompletionEntry(String keyword, String description, String output) {
            this.keyword = keyword;
            this.description = keyword + " (" + description + ")";
            if (output != null) {
                this.output = keyword + output;
            } else {
                output = null;
            }
            this.offset = 0;
            if (output != null) {
                if (output.endsWith("''")) {
                    this.offset = 1;
                } else if (output.endsWith("('')")) {
                    this.offset = 2;
                } else if (output.endsWith("[  ] ?") || output.endsWith("[  ] !")) {
                    this.offset = 4;
                }
            }
        }

        public String getKeyword() {
            return this.keyword;
        }

        public String getOutput() {
            return this.output;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.description;
        }
    }
}

