/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.Storage;
import java.io.File;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class ExitDialog {
    public ExitDialog(String title, String header, String content) {
        if (!GUI.started || !Boolean.parseBoolean(Storage.getInstance().getGuiConfigProperty("confirmExit"))) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
            alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
            alert.setTitle(title);
            alert.setHeaderText(header);
            CheckBox checkBox = null;
            if (GUI.started) {
                VBox box = new VBox(10.0);
                box.getChildren().add((Object)new Label(content));
                checkBox = new CheckBox("Do not ask again");
                box.getChildren().add((Object)checkBox);
                alert.getDialogPane().setContent((Node)box);
            } else {
                alert.setContentText(content);
            }
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                if (checkBox != null) {
                    Storage.getInstance().setGuiConfigProperty("confirmExit", String.valueOf(checkBox.isSelected()));
                }
                Platform.exit();
            } else {
                alert.hide();
            }
        } else {
            Platform.exit();
        }
    }
}

