/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.ui.gui.FontAwesome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FileChooserUIElement
extends BorderPane {
    public static final FileChooser.ExtensionFilter FILTER_ALL = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
    public static final FileChooser.ExtensionFilter FILTER_JAR = new FileChooser.ExtensionFilter("*.jar Java executable", new String[]{"*.jar"});
    public static final FileChooser.ExtensionFilter FILTER_SH = new FileChooser.ExtensionFilter("*.sh Bash script", new String[]{"*.sh"});
    public static final FileChooser.ExtensionFilter FILTER_BAT = new FileChooser.ExtensionFilter("*.bat Batch script", new String[]{"*.bat"});
    public static final FileChooser.ExtensionFilter FILTER_APK = new FileChooser.ExtensionFilter("*.apk Android Application Package", new String[]{"*.apk"});
    public static final FileChooser.ExtensionFilter FILTER_XML = new FileChooser.ExtensionFilter("*.xml AQL-Answer", new String[]{"*.xml"});
    private static File lastDirectory = new File(".");
    private final Stage stage;
    private final List<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
    private Button browseBtn;
    private final TextField textField;
    private boolean folder = false;
    private boolean save = false;
    private FileChooser.ExtensionFilter initFilter;

    public FileChooserUIElement(Stage stage, String btnToolTip) {
        this.filters.add(FILTER_ALL);
        this.filters.add(FILTER_JAR);
        this.filters.add(FILTER_SH);
        this.filters.add(FILTER_BAT);
        this.initFilter = FILTER_ALL;
        this.stage = stage;
        this.textField = new TextField();
        this.textField.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.setCenter((Node)this.textField);
        if (btnToolTip != null) {
            this.textField.setStyle("-fx-background-radius: 2.5 0 0 2.5;");
            this.browseBtn = new Button("\uf115");
            FontAwesome.applyFontAwesome((Control)this.browseBtn, "-fx-background-radius: 0 2.5 2.5 0;");
            this.browseBtn.setTooltip(new Tooltip(btnToolTip));
            this.browseBtn.setPrefHeight(25.0);
            this.browseBtn.setOnAction(eh -> this.buttonClicked());
            BorderPane.setAlignment((Node)this.browseBtn, (Pos)Pos.CENTER);
            this.setRight((Node)this.browseBtn);
        }
    }

    public void setNumeric() {
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    FileChooserUIElement.this.textField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
    }

    public void setFolder() {
        this.folder = true;
    }

    public void setSave() {
        this.save = true;
    }

    public TextField getTextField() {
        return this.textField;
    }

    public Button getButton() {
        return this.browseBtn;
    }

    public List<FileChooser.ExtensionFilter> getFilters() {
        return this.filters;
    }

    public void setInitFilter(FileChooser.ExtensionFilter filter) {
        this.initFilter = filter;
    }

    void buttonClicked() {
        File file;
        if (this.folder) {
            DirectoryChooser chooser = new DirectoryChooser();
            if (lastDirectory != null) {
                chooser.setInitialDirectory(lastDirectory);
            }
            file = chooser.showDialog((Window)this.stage);
        } else {
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().addAll(this.filters);
            chooser.setSelectedExtensionFilter(this.initFilter);
            if (lastDirectory != null) {
                chooser.setInitialDirectory(lastDirectory);
            }
            file = this.save ? chooser.showSaveDialog((Window)this.stage) : chooser.showOpenDialog((Window)this.stage);
        }
        if (file != null) {
            this.textField.setText(file.getAbsolutePath());
            lastDirectory = file.isDirectory() ? file : file.getParentFile();
        }
    }
}

