/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.Properties;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.FileHelper;
import de.foellix.aql.system.AQLSystem;
import de.foellix.aql.system.Options;
import de.foellix.aql.ui.gui.Editor;
import de.foellix.aql.ui.gui.ExitDialog;
import de.foellix.aql.ui.gui.IGUI;
import de.foellix.aql.ui.gui.SplashScreen;
import de.foellix.aql.ui.gui.Storage;
import de.foellix.aql.ui.gui.Viewer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class GUI
extends Application
implements IGUI {
    private static final int[] DEFAULT_POSITION_AND_SIZE = new int[]{-1, -1};
    public static Stage stage;
    private AQLSystem aqlSystem;
    public static TabPane tabs;
    public static Tab tabEditor;
    public static Tab tabViewer;
    public static Editor editor;
    public static Viewer viewer;
    private FileChooser openDialog;
    private FileChooser saveDialog;
    private FileChooser.ExtensionFilter allFilter;
    private FileChooser.ExtensionFilter aqlFilter;
    private FileChooser.ExtensionFilter xmlFilter;
    private File currentQuery;
    private File currentAnswer;
    public static boolean viewerActive;
    public static boolean started;
    public static Options options;
    private long time;

    public void start(Stage stage) throws Exception {
        this.time = System.currentTimeMillis();
        this.init(stage);
        editor.init(this);
        viewer.init(this);
        Log.msg("Initialization took: " + (System.currentTimeMillis() - this.time) + "ms", 6);
        if (SplashScreen.SPLASH_SCREEN.exists() && !options.getNoSplashScreen()) {
            SplashScreen splashScreen = new SplashScreen(Properties.info().ABBREVIATION + " (v. " + Properties.info().VERSION + ")", "by " + Properties.info().AUTHOR, Color.WHITE);
            new Thread(() -> {
                try {
                    this.time = System.currentTimeMillis() - this.time;
                    if (this.time < 3000L) {
                        Thread.sleep(3000L - this.time);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    splashScreen.setDone(true);
                    this.showConfigWizard();
                });
            }).start();
        } else {
            this.showConfigWizard();
        }
    }

    private void init(Stage stage) {
        int[] size;
        int[] position;
        Log.setSilence(false);
        try {
            position = Arrays.stream(Storage.getInstance().getGuiConfigProperty("windowPosition").replace(" ", "").split(",")).mapToInt(Integer::parseInt).toArray();
            if (position.length < 2) {
                position = DEFAULT_POSITION_AND_SIZE;
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            position = DEFAULT_POSITION_AND_SIZE;
        }
        try {
            size = Arrays.stream(Storage.getInstance().getGuiConfigProperty("windowSize").replace(" ", "").split(",")).mapToInt(Integer::parseInt).toArray();
            if (size.length < 2) {
                position = DEFAULT_POSITION_AND_SIZE;
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            size = DEFAULT_POSITION_AND_SIZE;
        }
        GUI.stage = stage;
        stage.setTitle("AQL-Editor");
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        tabs = new TabPane();
        if (position[0] >= 0) {
            stage.setX((double)position[0]);
        }
        if (position[1] >= 0) {
            stage.setY((double)position[1]);
        }
        Scene scene = size[0] >= 0 && size[1] >= 0 ? new Scene((Parent)tabs, (double)size[0], (double)size[1]) : new Scene((Parent)tabs, 1024.0, 768.0);
        if (Boolean.parseBoolean(Storage.getInstance().getGuiConfigProperty("fullScreen"))) {
            stage.setMaximized(true);
        }
        scene.getStylesheets().add((Object)new File("data/gui/style.css").toURI().toString());
        scene.getStylesheets().add((Object)new File("data/gui/keywords.css").toURI().toString());
        scene.getStylesheets().add((Object)new File("data/gui/highlight.css").toURI().toString());
        scene.getStylesheets().add((Object)new File("data/gui/executionGraph.css").toURI().toString());
        stage.setScene(scene);
        started = true;
        Log.enableGUIlogging();
        this.aqlSystem = new AQLSystem(options);
        editor = new Editor();
        viewer = new Viewer();
        tabEditor = new Tab("Editor");
        tabEditor.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                viewerActive = false;
                GUI.this.adjustTitle();
            }
        });
        tabEditor.setGraphic((Node)new ImageView(new Image(new File("data/gui/images/editor_icon_32.png").toURI().toString(), 32.0, 32.0, false, true)));
        tabEditor.setContent((Node)editor);
        tabEditor.setClosable(false);
        tabViewer = new Tab("Viewer");
        tabViewer.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                viewerActive = true;
                GUI.this.adjustTitle();
            }
        });
        tabViewer.setGraphic((Node)new ImageView(new Image(new File("data/gui/images/viewer_icon_32.png").toURI().toString(), 32.0, 32.0, false, true)));
        tabViewer.setContent((Node)viewer);
        tabViewer.setClosable(false);
        tabs.getTabs().addAll((Object[])new Tab[]{tabEditor, tabViewer});
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                we.consume();
                GUI.this.exit();
            }
        });
        this.openDialog = new FileChooser();
        this.saveDialog = new FileChooser();
        this.allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
        this.aqlFilter = new FileChooser.ExtensionFilter("*.aql AQL-Query", new String[]{"*.aql"});
        this.xmlFilter = new FileChooser.ExtensionFilter("*.xml AQL-Answer", new String[]{"*.xml"});
        scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            }
        });
        scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    if (viewerActive) {
                        GUI.this.open((File)db.getFiles().get(0));
                    } else if (((File)db.getFiles().get(0)).getName().endsWith(".aql")) {
                        GUI.this.open((File)db.getFiles().get(0));
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < db.getFiles().size(); ++i) {
                            File file = (File)db.getFiles().get(i);
                            sb.append((i == 0 ? "" : " ") + file.getAbsolutePath());
                        }
                        editor.insert(sb.toString());
                    }
                }
                event.setDropCompleted(success);
                event.consume();
            }
        });
    }

    private void showConfigWizard() {
        if (!options.getShowConfigWizard()) {
            stage.show();
            ConfigHandler.getInstance().getConfig();
        } else {
            ConfigWizard cw = new ConfigWizard(stage, ConfigHandler.getInstance().getConfigFile(), true);
            cw.getStage().setOnCloseRequest(event -> System.exit(0));
        }
    }

    @Override
    public void newFile() {
        if (!viewerActive) {
            editor.resetContent();
            this.currentQuery = null;
        } else {
            viewer.resetContent();
            this.currentAnswer = null;
        }
    }

    @Override
    public void open() {
        this.openDialog.getExtensionFilters().clear();
        if (!viewerActive) {
            this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.aqlFilter});
            this.openDialog.setSelectedExtensionFilter(this.aqlFilter);
            if (this.currentQuery != null) {
                this.openDialog.setInitialDirectory(this.currentQuery.getParentFile());
            } else {
                this.openDialog.setInitialDirectory(new File("queries"));
            }
        } else {
            this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.xmlFilter});
            this.openDialog.setSelectedExtensionFilter(this.xmlFilter);
            if (this.currentAnswer != null) {
                this.openDialog.setInitialDirectory(this.currentAnswer.getParentFile());
            } else {
                this.openDialog.setInitialDirectory(FileHelper.getAnswersDirectory());
            }
        }
        this.open(this.openDialog.showOpenDialog((Window)this.getStage()));
    }

    public void open(File file) {
        if (file != null) {
            try {
                if (!viewerActive) {
                    editor.openFile(file);
                    this.currentQuery = file;
                    Storage.getInstance().store(file, 0);
                } else {
                    viewer.openFile(file);
                    this.currentAnswer = file;
                    Storage.getInstance().store(file, 1);
                }
            }
            catch (FileNotFoundException e) {
                Log.msg("File not found: " + file.toString(), 1);
            }
            catch (Exception e) {
                Log.msg("Error occurred while opening file: " + file.toString() + Log.getExceptionAppendix(e), 1);
            }
        }
        this.adjustTitle();
    }

    @Override
    public void saveAs() {
        this.saveDialog.getExtensionFilters().clear();
        if (!viewerActive) {
            this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.aqlFilter});
            this.saveDialog.setSelectedExtensionFilter(this.aqlFilter);
            if (this.currentQuery != null) {
                this.saveDialog.setInitialDirectory(this.currentQuery.getParentFile());
            } else {
                this.saveDialog.setInitialDirectory(new File("queries"));
            }
            this.currentQuery = this.saveDialog.showSaveDialog((Window)this.getStage());
            if (this.currentQuery != null) {
                this.save();
            }
        } else {
            this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.xmlFilter});
            this.saveDialog.setSelectedExtensionFilter(this.xmlFilter);
            if (this.currentAnswer != null) {
                this.saveDialog.setInitialDirectory(this.currentAnswer.getParentFile());
            } else {
                this.saveDialog.setInitialDirectory(FileHelper.getAnswersDirectory());
            }
            this.currentAnswer = this.saveDialog.showSaveDialog((Window)this.getStage());
            if (this.currentAnswer != null) {
                this.save();
            }
        }
    }

    @Override
    public void save() {
        if (!viewerActive) {
            if (this.currentQuery == null) {
                this.saveAs();
            } else {
                this.save(this.currentQuery);
            }
        } else if (this.currentAnswer == null) {
            this.saveAs();
        } else {
            this.save(this.currentAnswer);
        }
    }

    private void save(File file) {
        if (!viewerActive) {
            try {
                file.delete();
                Files.write(file.toPath(), editor.getContent().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                Log.msg("Could not write file: " + file.getAbsolutePath() + " (" + e.getMessage() + ")", 1);
            }
            Storage.getInstance().store(file, 0);
        } else {
            Answer temp = AnswerHandler.parseXML(GUI.viewer.viewerXML.getContent());
            if (temp == null) {
                temp = new Answer();
            }
            AnswerHandler.createXML(temp, file);
            Storage.getInstance().store(file, 1);
        }
        this.adjustTitle();
    }

    @Override
    public void exit() {
        Storage.getInstance().setGuiConfigProperty("fullScreen", String.valueOf(stage.isMaximized()));
        if (!stage.isMaximized()) {
            Storage.getInstance().setGuiConfigProperty("windowPosition", (int)stage.getX() + ", " + (int)stage.getY());
            Storage.getInstance().setGuiConfigProperty("windowSize", (int)stage.getScene().getWidth() + ", " + (int)stage.getScene().getHeight());
        }
        new ExitDialog("Exit", "You will exit the " + Properties.info().ABBREVIATION + " now.", "Proceed?");
    }

    private void adjustTitle() {
        Platform.runLater(() -> {
            if (viewerActive) {
                if (this.currentAnswer == null) {
                    this.getStage().setTitle("AQL-Viewer");
                } else {
                    this.getStage().setTitle("AQL-Viewer (" + this.currentAnswer.getAbsolutePath() + ")");
                }
            } else if (this.currentQuery == null) {
                this.getStage().setTitle("AQL-Editor");
            } else {
                this.getStage().setTitle("AQL-Editor (" + this.currentQuery.getAbsolutePath() + ")");
            }
        });
    }

    @Override
    public Stage getStage() {
        return stage;
    }

    @Override
    public AQLSystem getSystem() {
        return this.aqlSystem;
    }

    public static void switchToEditor() {
        tabs.getSelectionModel().select((Object)tabEditor);
    }

    public static void switchToViewer() {
        tabs.getSelectionModel().select((Object)tabViewer);
    }

    public static void ask() {
        editor.ask();
    }

    public static void alert(boolean error, String title, String header, String msg) {
        Platform.runLater(() -> {
            Alert alert = GUI.getAlertTemplate(error, title, header, msg);
            alert.setContentText(msg);
            alert.show();
        });
    }

    public static void alert(boolean error, String title, String header, Pane pane) {
        Platform.runLater(() -> {
            Alert alert = GUI.getAlertTemplate(error, title, header, "");
            alert.getDialogPane().setContent((Node)pane);
            alert.initModality(Modality.NONE);
            alert.show();
        });
    }

    private static Alert getAlertTemplate(boolean error, String title, String header, String msg) {
        Alert alert = new Alert(error ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        if (header.length() > 100 || msg.length() > 100) {
            alert.getDialogPane().setPrefWidth(600.0);
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        return alert;
    }

    static {
        viewerActive = false;
        started = false;
        options = new Options();
    }
}

