/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.helper.GUIHelper;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.LogMsg;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;

public class LogViewer
extends TitledPane {
    private static ListView<LogMsg> logArea = new ListView();

    public LogViewer() {
        this.setText("Log");
        this.setContent((Node)logArea);
        logArea.setCellFactory(item1 -> new LogViewerListViewCell());
        logArea.setStyle("-fx-font-family: Consolas;");
        logArea.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        logArea.setOnKeyPressed(e -> {
            if (e.isControlDown() && (e.getCode() == KeyCode.C || e.getCode() == KeyCode.X)) {
                this.copyToClipboard();
            }
        });
        logArea.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2 || e.getButton() == MouseButton.SECONDARY) {
                this.copyToClipboard();
            }
        });
        GUIHelper.makeResizableInHeight(logArea, 200);
        this.setExpanded(false);
    }

    private void copyToClipboard() {
        StringBuilder sb = new StringBuilder();
        for (LogMsg msg : logArea.getSelectionModel().getSelectedItems()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(msg.getMsg());
        }
        GUIHelper.copyToClipboard(sb.toString());
    }

    public static void log(LogMsg msg) {
        if (GUI.started) {
            String temp = Log.stripAnsi(msg.getMsg());
            while (temp.endsWith(" ") || temp.endsWith("\n") || temp.endsWith("\r") || temp.endsWith("\t")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            while (temp.startsWith("\n") || temp.startsWith("\r")) {
                temp = temp.substring(1);
            }
            msg.setMsg(temp);
            Platform.runLater(() -> logArea.getItems().add(0, (Object)msg));
        }
    }

    private class LogViewerListViewCell
    extends ListCell<LogMsg> {
        private LogViewerListViewCell() {
        }

        protected void updateItem(LogMsg item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null) {
                this.setText(item.toString());
                this.setGraphic(this.getIcon(item.getType()));
            }
        }

        private Node getIcon(int type) {
            Label icon;
            switch (type) {
                case 2: {
                    icon = new Label("\uf071");
                    FontAwesome.applyFontAwesome((Control)icon, "-fx-text-fill: #ffdd21; -fx-font-size: 15px;");
                    break;
                }
                case 3: {
                    icon = new Label("\uf06a");
                    FontAwesome.applyFontAwesome((Control)icon, "-fx-text-fill: #a40000; -fx-font-size: 15px;");
                    break;
                }
                case 1: {
                    icon = new Label("\uf05a");
                    FontAwesome.applyFontAwesome((Control)icon, "-fx-text-fill: #00a3db; -fx-font-size: 15px;");
                    break;
                }
                default: {
                    icon = new Label("");
                }
            }
            icon.setPrefWidth(25.0);
            return icon;
        }
    }
}

