/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.BackupAndResetMenu;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.IGUI;
import de.foellix.aql.ui.gui.Storage;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class MenuFile
extends Menu {
    private static final int FILENAME_MAX_LENGTH = 75;
    private IGUI parent;
    private boolean isEditor;
    private Menu menuItemOpenRecent;

    public MenuFile(IGUI parent) {
        this(parent, false);
    }

    public MenuFile(final IGUI parent, boolean isEditor) {
        super("File");
        this.parent = parent;
        this.isEditor = isEditor;
        if (parent instanceof GUI || parent instanceof ConfigWizard) {
            MenuItem menuItemNew = FontAwesome.getInstance().createMenuItem("\uf016", "New");
            menuItemNew.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
            menuItemNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    parent.newFile();
                }
            });
            MenuItem menuItemOpen = FontAwesome.getInstance().createMenuItem("\uf115", "Open..");
            menuItemOpen.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
            menuItemOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    parent.open();
                    MenuFile.this.refreshRecentFiles();
                }
            });
            this.menuItemOpenRecent = FontAwesome.getInstance().createInnerMenu("\uf115", "Open recent file");
            this.refreshRecentFiles();
            MenuItem menuItemSave = FontAwesome.getInstance().createMenuItem("\uf0c7", "Save");
            menuItemSave.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
            menuItemSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    parent.save();
                    MenuFile.this.refreshRecentFiles();
                }
            });
            MenuItem menuItemSaveAs = FontAwesome.getInstance().createMenuItem("\uf0c7", "Save as..");
            menuItemSaveAs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    parent.saveAs();
                    MenuFile.this.refreshRecentFiles();
                }
            });
            MenuItem menuItemResetGuiConfig = FontAwesome.getInstance().createMenuItem("\uf014", "Reset GUI configuration");
            menuItemResetGuiConfig.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Storage.getInstance().resetGuiConfig();
                }
            });
            MenuItem menuItemExit = FontAwesome.getInstance().createMenuItem("\uf011", "Exit");
            menuItemExit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    parent.exit();
                }
            });
            this.getItems().addAll((Object[])new MenuItem[]{menuItemNew, new SeparatorMenuItem(), menuItemOpen});
            if (this.parent instanceof GUI) {
                this.getItems().add((Object)this.menuItemOpenRecent);
            }
            this.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), menuItemSave, menuItemSaveAs, new SeparatorMenuItem()});
            this.getItems().addAll((Collection)new BackupAndResetMenu());
            this.getItems().addAll((Object[])new MenuItem[]{menuItemResetGuiConfig, new SeparatorMenuItem(), menuItemExit});
        }
    }

    public void refreshRecentFiles() {
        if (this.parent instanceof GUI) {
            this.menuItemOpenRecent.getItems().clear();
            List<File> fileList = this.isEditor ? Storage.getInstance().getRecentFiles(0) : Storage.getInstance().getRecentFiles(1);
            for (final File file : fileList) {
                Object text = file.getAbsolutePath();
                if (((String)text).length() > 83) {
                    text = ((String)text).substring(0, 20) + "..." + ((String)text).substring(((String)text).length() - 55);
                }
                MenuItem newMenuItem = FontAwesome.getInstance().createMenuItem(null, (String)text);
                newMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ((GUI)MenuFile.this.parent).open(file);
                        MenuFile.this.refreshRecentFiles();
                    }
                });
                this.menuItemOpenRecent.getItems().add((Object)newMenuItem);
            }
            if (this.menuItemOpenRecent.getItems().isEmpty()) {
                this.menuItemOpenRecent.setDisable(true);
            } else {
                this.menuItemOpenRecent.setDisable(false);
            }
        }
    }
}

