/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.system.IProgressChanged;
import de.foellix.aql.transformations.RulesHandler;
import de.foellix.aql.ui.gui.Editor;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class MenubarEditor
extends VBox
implements IProgressChanged {
    private final Editor parent;
    private final ProgressIndicator progressIndicator;
    private final Text progressText;
    private final ProgressBar progressBar;
    private final Button btnAsk;
    private final MenuItem menuItemAsk;

    MenubarEditor(final Editor parent) {
        this.parent = parent;
        MenuBar menuBar = new MenuBar();
        MenuFile menuFile = new MenuFile(parent.getParentGUI(), true);
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemAutocomplete = new MenuItem();
        menuItemAutocomplete.setVisible(false);
        menuItemAutocomplete.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemAutocomplete.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autocomplete(true);
            }
        });
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.redo();
            }
        });
        MenuItem menuItemAutoFormat = FontAwesome.getInstance().createMenuItem("\uf03c", "Auto-Format");
        menuItemAutoFormat.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN}));
        menuItemAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        MenuItem menuItemTransform = FontAwesome.getInstance().createMenuItem("\uf074", "Apply transformation rules");
        menuItemTransform.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.transform();
            }
        });
        if (RulesHandler.getInstance().getRules().isEmpty()) {
            menuItemTransform.setDisable(true);
        }
        MenuItem menuItemInsertFilename = FontAwesome.getInstance().createMenuItem("\uf0f6", "Insert Filename");
        menuItemInsertFilename.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.insertFilename();
            }
        });
        this.menuItemAsk = FontAwesome.getInstance().createMenuItem("\uf04b", "Ask Query");
        this.menuItemAsk.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuItemAsk.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.ask();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemAutocomplete, menuItemUndo, menuItemRedo, new SeparatorMenuItem(), menuItemAutoFormat, menuItemTransform, menuItemInsertFilename, new SeparatorMenuItem(), this.menuItemAsk});
        Menu menuView = new Menu("View");
        MenuItem menuItemZoomIn = FontAwesome.getInstance().createMenuItem("\uf00e", "Zoom in");
        menuItemZoomIn.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.PLUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomIn();
            }
        });
        MenuItem menuItemZoomOut = FontAwesome.getInstance().createMenuItem("\uf010", "Zoom out");
        menuItemZoomOut.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomOut();
            }
        });
        MenuItem menuItemZoomReset = FontAwesome.getInstance().createMenuItem("\uf002", "Reset zoom");
        menuItemZoomReset.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomReset();
            }
        });
        menuView.getItems().addAll((Object[])new MenuItem[]{menuItemZoomIn, menuItemZoomOut, menuItemZoomReset});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuEdit, menuView, new MenuHelp(parent.getParentGUI().getStage())});
        ToolBar toolBar = new ToolBar();
        Button btnAutoFormat = FontAwesome.getInstance().createButton("\uf03c");
        btnAutoFormat.setTooltip(new Tooltip("Auto-Format"));
        btnAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        Button btnTransform = FontAwesome.getInstance().createButton("\uf074");
        btnTransform.setTooltip(new Tooltip("Apply transformation rules"));
        btnTransform.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.transform();
            }
        });
        if (RulesHandler.getInstance().getRules().isEmpty()) {
            btnTransform.setDisable(true);
        }
        Button btnInsertFilename = FontAwesome.getInstance().createButton("\uf0f6");
        btnInsertFilename.setTooltip(new Tooltip("Insert Filename"));
        btnInsertFilename.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.insertFilename();
            }
        });
        HBox progressBox = new HBox(10.0);
        HBox.setHgrow((Node)progressBox, (Priority)Priority.ALWAYS);
        HBox indicatorBox = new HBox(0.0);
        indicatorBox.setAlignment(Pos.CENTER_LEFT);
        this.progressIndicator = new ProgressIndicator(-1.0);
        this.progressIndicator.setMaxWidth(25.0);
        this.progressIndicator.setMaxHeight(25.0);
        this.progressIndicator.setVisible(false);
        indicatorBox.getChildren().add((Object)this.progressIndicator);
        VBox innerProgressBox = new VBox(0.0);
        this.progressText = new Text("0% (0 of 0)");
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setPrefWidth(300.0);
        innerProgressBox.getChildren().addAll((Object[])new Node[]{this.progressText, this.progressBar});
        progressBox.getChildren().addAll((Object[])new Node[]{innerProgressBox});
        this.btnAsk = FontAwesome.getInstance().createButton("\uf04b");
        this.btnAsk.setTooltip(new Tooltip("Ask Query"));
        FontAwesome.getInstance().setGreen(this.btnAsk);
        this.btnAsk.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.ask();
            }
        });
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent.getParentGUI(), menuFile), new Separator(), btnAutoFormat, btnTransform, btnInsertFilename, new Separator(), progressBox, indicatorBox, this.btnAsk});
        this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
    }

    @Override
    public void onProgressChanged(String step, int inProgress, int done, int max) {
        Platform.runLater(() -> {
            float percentage = max == 0 ? 0.0f : (float)done / (float)max;
            this.progressText.setText(step + " - " + Math.round(percentage * 100.0f) + "% (In Progress: " + inProgress + ", Finished: " + done + " of " + max + ")");
            this.progressBar.setProgress((double)percentage);
            if (done < max) {
                this.parent.setStop(true);
                this.progressIndicator.setVisible(true);
                FontAwesome.getInstance().setRed(this.btnAsk);
                this.btnAsk.setText("\uf04d");
                this.disableButtonTimed(this.btnAsk, 2000);
            } else {
                this.parent.setStop(false);
                this.progressIndicator.setVisible(false);
                FontAwesome.getInstance().setGreen(this.btnAsk);
                this.btnAsk.setText("\uf04b");
                this.disableButtonTimed(this.btnAsk, 2000);
            }
        });
    }

    private void disableButtonTimed(Button btn, int timeInMS) {
        btn.setDisable(true);
        new Thread(() -> {
            try {
                Thread.sleep(timeInMS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                Platform.runLater(() -> btn.setDisable(false));
            }
        }).start();
    }
}

