/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import de.foellix.aql.ui.gui.Viewer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MenubarViewer
extends VBox {
    public static final int MODE_VIEWER_XML = 0;
    public static final int MODE_VIEWER_GRAPH = 1;
    public static final int MODE_VIEWER_WEB = 2;
    private Label[] stats = new Label[8];
    private final Button btnInBrowser;

    MenubarViewer(final Viewer parent) {
        MenuBar menuBar = new MenuBar();
        MenuFile menuFile = new MenuFile(parent.getParentGUI(), false);
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.viewerXML.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.viewerXML.redo();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemUndo, menuItemRedo});
        Menu menuView = new Menu("View");
        MenuItem menuItemRefreshGraph = FontAwesome.getInstance().createMenuItem("\uf021", "Refresh Graph & Statistics");
        menuItemRefreshGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.refreshGraph();
            }
        });
        MenuItem menuItemInBrowser = FontAwesome.getInstance().createMenuItem("\uf0ac", "Open in browser");
        menuItemInBrowser.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemInBrowser.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.inBrowser();
            }
        });
        CheckMenuItem menuConsiderLinenumbers = FontAwesome.getInstance().createCheckMenuItem("Consider Linenumbers (while drawing graph)");
        menuConsiderLinenumbers.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.viewerWeb.setConsiderLinenumbers(((CheckMenuItem)event.getSource()).isSelected());
                parent.refreshGraph();
            }
        });
        menuConsiderLinenumbers.setSelected(true);
        menuView.getItems().addAll((Object[])new MenuItem[]{menuItemRefreshGraph, menuItemInBrowser, new SeparatorMenuItem(), menuConsiderLinenumbers});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuEdit, menuView, new MenuHelp(parent.getParentGUI().getStage())});
        ToolBar toolBar = new ToolBar();
        Button btnRefreshGraph = FontAwesome.getInstance().createButton("\uf021");
        btnRefreshGraph.setTooltip(new Tooltip("Refresh Graph & Statistics"));
        btnRefreshGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.refreshGraph();
            }
        });
        HBox statsOuterBox = new HBox(10.0);
        VBox statsInnerBox1 = new VBox(0.0);
        VBox statsInnerBox2 = new VBox(0.0);
        VBox statsInnerBox3 = new VBox(0.0);
        VBox statsInnerBox4 = new VBox(0.0);
        this.stats[0] = new Label("Flows: ");
        this.stats[1] = new Label("Permissions: ");
        this.stats[2] = new Label("Intents: ");
        this.stats[3] = new Label("IntentFilters: ");
        this.stats[4] = new Label("IntentSinks: ");
        this.stats[5] = new Label("IntentSources: ");
        this.stats[6] = new Label("Sources: ");
        this.stats[7] = new Label("Sinks: ");
        statsInnerBox1.getChildren().addAll((Object[])new Node[]{this.stats[0], this.stats[1]});
        statsInnerBox2.getChildren().addAll((Object[])new Node[]{this.stats[2], this.stats[3]});
        statsInnerBox3.getChildren().addAll((Object[])new Node[]{this.stats[4], this.stats[5]});
        statsInnerBox4.getChildren().addAll((Object[])new Node[]{this.stats[6], this.stats[7]});
        statsOuterBox.getChildren().addAll((Object[])new Node[]{statsInnerBox1, statsInnerBox2, statsInnerBox3, statsInnerBox4});
        HBox spacer = new HBox();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.btnInBrowser = FontAwesome.getInstance().createButton("\uf0ac");
        this.btnInBrowser.setTooltip(new Tooltip("Open in browser"));
        this.btnInBrowser.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.inBrowser();
            }
        });
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent.getParentGUI(), menuFile), new Separator(), btnRefreshGraph, new Separator(), statsOuterBox, spacer, this.btnInBrowser});
        if (parent.getParentGUI() instanceof GUI) {
            this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
        } else {
            this.getChildren().addAll((Object[])new Node[]{toolBar});
        }
    }

    public void refresh(Answer answer) {
        if (answer != null) {
            if (answer.getFlows() != null) {
                this.stats[0].setText("Flows: " + answer.getFlows().getFlow().size());
            } else {
                this.stats[0].setText("Flows: 0");
            }
            if (answer.getPermissions() != null) {
                this.stats[1].setText("Permissions: " + answer.getPermissions().getPermission().size());
            } else {
                this.stats[1].setText("Permissions: 0");
            }
            if (answer.getIntents() != null) {
                this.stats[2].setText("Intents: " + answer.getIntents().getIntent().size());
            } else {
                this.stats[2].setText("Intents: 0");
            }
            if (answer.getIntentfilters() != null) {
                this.stats[3].setText("IntentFilters: " + answer.getIntentfilters().getIntentfilter().size());
            } else {
                this.stats[3].setText("IntentFilters: 0");
            }
            if (answer.getIntentsinks() != null) {
                this.stats[4].setText("IntentSinks: " + answer.getIntentsinks().getIntentsink().size());
            } else {
                this.stats[4].setText("IntentSinks: 0");
            }
            if (answer.getIntentsources() != null) {
                this.stats[5].setText("IntentSources: " + answer.getIntentsources().getIntentsource().size());
            } else {
                this.stats[5].setText("IntentSources: 0");
            }
            if (answer.getSources() != null) {
                this.stats[6].setText("Sources: " + answer.getSources().getSource().size());
            } else {
                this.stats[6].setText("Sources: 0");
            }
            if (answer.getSinks() != null) {
                this.stats[7].setText("Sinks: " + answer.getSinks().getSink().size());
            } else {
                this.stats[7].setText("Sinks: 0");
            }
        } else {
            this.stats[0].setText("Flows: 0");
            this.stats[1].setText("Permissions: 0");
            this.stats[2].setText("Intents: 0");
            this.stats[3].setText("IntentFilters: 0");
            this.stats[4].setText("IntentSinks: 0");
            this.stats[5].setText("IntentSources: 0");
            this.stats[6].setText("Sources: 0");
            this.stats[7].setText("Sinks: 0");
        }
    }

    public void buttonState(int mode) {
        if (mode == 0) {
            this.btnInBrowser.setDisable(true);
        } else if (mode == 1) {
            this.btnInBrowser.setDisable(true);
        } else {
            this.btnInBrowser.setDisable(false);
        }
    }
}

