/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import java.io.File;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ProgressDialog
extends Stage {
    private final ProgressBar progressBar1;
    private final ProgressBar progressBar2;
    private final Label labelStatus1;
    private final Label labelStatus2;

    public ProgressDialog() {
        this.setTitle("Loading...");
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        this.resizableProperty().setValue(Boolean.valueOf(false));
        this.setOnCloseRequest(e -> e.consume());
        GridPane mainPane = new GridPane();
        mainPane.setHgap(10.0);
        mainPane.setVgap(10.0);
        mainPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Label label1 = new Label("Total: ");
        this.progressBar1 = new ProgressBar();
        this.progressBar1.setPrefWidth(175.0);
        this.labelStatus1 = new Label("0% (0/0)");
        mainPane.add((Node)label1, 0, 0);
        mainPane.add((Node)this.progressBar1, 1, 0);
        mainPane.add((Node)this.labelStatus1, 2, 0);
        Label label2 = new Label("Current: ");
        this.progressBar2 = new ProgressBar();
        this.progressBar2.setPrefWidth(175.0);
        this.labelStatus2 = new Label("0% (0/0)");
        mainPane.add((Node)label2, 0, 1);
        mainPane.add((Node)this.progressBar2, 1, 1);
        mainPane.add((Node)this.labelStatus2, 2, 1);
        Scene scene = new Scene((Parent)mainPane, 400.0, 70.0);
        scene.getStylesheets().add((Object)new File("data/gui/style.css").toURI().toString());
        this.setScene(scene);
        this.show();
    }

    public void updateProgress(int currentDone, int currentMax, int totalDone, int totalMax) {
        Platform.runLater(() -> {
            this.progressBar1.setProgress((double)totalDone / (double)totalMax);
            this.labelStatus1.setText((int)Math.floor((double)totalDone / (double)totalMax * 100.0) + "% (" + totalDone + "/" + totalMax + ")");
            this.progressBar2.setProgress((double)currentDone / (double)currentMax);
            this.labelStatus2.setText((int)Math.floor((double)currentDone / (double)currentMax * 100.0) + "% (" + currentDone + "/" + currentMax + ")");
            if (totalDone >= totalMax) {
                this.hide();
            }
        });
    }
}

