/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.fxmisc.richtext.CodeArea;

public class SearchAndReplaceBox {
    private Dialog<ButtonType> dialog;
    private CodeArea ta;
    private TextField needle;
    private boolean close;
    private int offset;
    private int caret;

    public SearchAndReplaceBox(CodeArea ta) {
        this(ta, null);
    }

    public SearchAndReplaceBox(CodeArea ta, String titleAddition) {
        this.ta = ta;
        ta.focusedProperty().addListener((observable, oldValue, newValue) -> {
            this.caret = this.ta.getSelectedText() != null && !this.ta.getSelectedText().isEmpty() ? ta.getSelection().getStart() : ta.getCaretPosition();
            this.offset = -1;
        });
        this.dialog = this.init(titleAddition);
        this.close = false;
        this.offset = -1;
        this.caret = ta.getCaretPosition();
    }

    public void show() {
        if (this.ta.getSelectedText() != null && !this.ta.getSelectedText().isEmpty()) {
            this.needle.setText(this.ta.getSelectedText());
        }
        if (!this.dialog.isShowing()) {
            this.dialog.show();
            this.needle.requestFocus();
        } else {
            this.toFront((Node)this.needle);
        }
    }

    private void toFront(Node focus) {
        ((Stage)this.dialog.getDialogPane().getScene().getWindow()).toFront();
        focus.requestFocus();
    }

    private Dialog<ButtonType> init(String titleAddition) {
        final Dialog dialog = new Dialog();
        if (titleAddition == null) {
            dialog.setTitle("Search and Replace");
        } else {
            dialog.setTitle("Search and Replace (" + titleAddition + ")");
        }
        dialog.setHeaderText(null);
        dialog.setGraphic(null);
        Stage stage = (Stage)dialog.getDialogPane().getScene().getWindow();
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        stage.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        dialog.getDialogPane().getScene().getStylesheets().add((Object)new File("data/gui/style.css").toURI().toString());
        final Button btnSearch = new Button("Search");
        final Button btnReplace = new Button("Replace");
        final ButtonType btnReplaceAndSearch = new ButtonType("Replace & Search");
        final ButtonType btnReplaceAll = new ButtonType("Replace All");
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{btnReplaceAndSearch, btnReplaceAll, ButtonType.CANCEL});
        dialog.initModality(Modality.WINDOW_MODAL);
        this.needle = new TextField();
        this.needle.setPrefWidth(225.0);
        if (this.ta.getSelectedText() != null && !this.ta.getSelectedText().isEmpty()) {
            this.needle.setText(this.ta.getSelectedText());
        } else {
            btnSearch.setDisable(true);
            btnReplace.setDisable(true);
            dialog.getDialogPane().lookupButton(btnReplaceAndSearch).setDisable(true);
            dialog.getDialogPane().lookupButton(btnReplaceAll).setDisable(true);
        }
        final TextField replacement = new TextField();
        replacement.setPrefWidth(225.0);
        if (this.ta.getSelectedText() == null || this.ta.getSelectedText().isEmpty()) {
            btnReplace.setDisable(true);
            dialog.getDialogPane().lookupButton(btnReplaceAndSearch).setDisable(true);
            dialog.getDialogPane().lookupButton(btnReplaceAll).setDisable(true);
        }
        ChangeListener<String> listener = new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (SearchAndReplaceBox.this.needle.getText() != null && !SearchAndReplaceBox.this.needle.getText().isEmpty()) {
                    btnSearch.setDisable(false);
                    if (replacement.getText() != null && !replacement.getText().isEmpty()) {
                        btnReplace.setDisable(false);
                        dialog.getDialogPane().lookupButton(btnReplaceAndSearch).setDisable(false);
                        dialog.getDialogPane().lookupButton(btnReplaceAll).setDisable(false);
                    } else {
                        btnReplace.setDisable(true);
                        dialog.getDialogPane().lookupButton(btnReplaceAndSearch).setDisable(true);
                        dialog.getDialogPane().lookupButton(btnReplaceAll).setDisable(true);
                    }
                } else {
                    btnSearch.setDisable(true);
                    btnReplace.setDisable(true);
                    dialog.getDialogPane().lookupButton(btnReplaceAndSearch).setDisable(true);
                    dialog.getDialogPane().lookupButton(btnReplaceAll).setDisable(true);
                }
            }
        };
        this.needle.textProperty().addListener((ChangeListener)listener);
        replacement.textProperty().addListener((ChangeListener)listener);
        this.needle.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.search();
            }
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.add((Node)new Label("Search:"), 0, 0);
        grid.add((Node)this.needle, 1, 0);
        grid.add((Node)btnSearch, 2, 0);
        btnSearch.setPrefWidth(109.0);
        grid.add((Node)new Label("Replace by:"), 0, 1);
        grid.add((Node)replacement, 1, 1);
        grid.add((Node)btnReplace, 2, 1);
        btnReplace.setPrefWidth(109.0);
        dialog.getDialogPane().setContent((Node)grid);
        btnSearch.setOnAction(e -> {
            this.search();
            this.toFront((Node)btnSearch);
        });
        btnReplace.setOnAction(e -> {
            this.ta.replaceSelection(replacement.getText());
            this.toFront((Node)btnReplace);
        });
        ((Button)dialog.getDialogPane().lookupButton(btnReplaceAndSearch)).setOnAction(e -> {
            this.ta.replaceSelection(replacement.getText());
            this.search();
            e.consume();
        });
        ((Button)dialog.getDialogPane().lookupButton(btnReplaceAll)).setOnAction(e -> {
            int caretPos = this.ta.getCaretPosition();
            while (this.search()) {
                this.ta.replaceSelection(replacement.getText());
            }
            this.ta.moveTo(caretPos);
            this.offset = caretPos;
            this.toFront(dialog.getDialogPane().lookupButton(btnReplaceAll));
            e.consume();
        });
        ((Button)dialog.getDialogPane().lookupButton(ButtonType.CANCEL)).setOnAction(e -> {
            this.close = true;
            dialog.hide();
        });
        dialog.setOnCloseRequest(e -> {
            if (!this.close) {
                e.consume();
            } else {
                this.close = false;
            }
        });
        return dialog;
    }

    public boolean search() {
        if (this.offset == -1) {
            this.ta.moveTo(this.caret);
        }
        this.offset = this.ta.getCaretPosition();
        int start = this.ta.getText().indexOf(this.needle.getText(), this.offset);
        if (start < 0) {
            this.offset = 0;
            start = this.ta.getText().indexOf(this.needle.getText(), this.offset);
        }
        if (start >= 0) {
            this.ta.requestFollowCaret();
            this.ta.selectRange(start, start + this.needle.getText().length());
            return true;
        }
        return false;
    }
}

