/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import java.io.File;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class SplashScreen
extends Stage {
    public static final File SPLASH_SCREEN = new File("data/gui/images/splash.png");
    private boolean done;

    public SplashScreen(String title, String version, Color color) {
        this.setTitle(title);
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_16.png").toURI().toString(), 16.0, 16.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_32.png").toURI().toString(), 32.0, 32.0, false, true));
        this.getIcons().add((Object)new Image(new File("data/gui/images/icon_64.png").toURI().toString(), 64.0, 64.0, false, true));
        this.initStyle(StageStyle.TRANSPARENT);
        BorderPane mainPane = new BorderPane();
        mainPane.setStyle("-fx-background-color: rgba(0, 0, 0, 0);");
        mainPane.setPadding(new Insets(20.0, 20.0, 20.0, 20.0));
        BorderPane splash = new BorderPane();
        splash.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        BackgroundImage bg = new BackgroundImage(new Image(SPLASH_SCREEN.toURI().toString()), BackgroundRepeat.REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
        splash.setBackground(new Background(new BackgroundImage[]{bg}));
        DropShadow shadow = new DropShadow();
        shadow.setRadius(17.0);
        shadow.setOffsetX(3.0);
        shadow.setOffsetY(3.0);
        splash.setEffect((Effect)shadow);
        ProgressBar progressBar = new ProgressBar(-1.0);
        progressBar.setPrefWidth(2.147483647E9);
        splash.setBottom((Node)progressBar);
        BorderPane titlePane = new BorderPane();
        Text titleLabel = new Text(title);
        titleLabel.setFill((Paint)color);
        titlePane.setLeft((Node)titleLabel);
        Text versionLabel = new Text(version);
        versionLabel.setFill((Paint)color);
        titlePane.setRight((Node)versionLabel);
        splash.setTop((Node)titlePane);
        mainPane.setCenter((Node)splash);
        Scene scene = new Scene((Parent)mainPane, 840.0, 540.0);
        scene.getStylesheets().add((Object)new File("data/gui/style.css").toURI().toString());
        scene.setFill((Paint)Color.TRANSPARENT);
        this.setScene(scene);
        this.show();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
        if (done) {
            this.hide();
        }
    }
}

