/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.ui.gui.RecentFileList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class Storage {
    public static final int TYPE_QUERIES = 0;
    public static final int TYPE_ANSWERS = 1;
    public static final int TYPE_FILES = 2;
    public static final String PROPERTY_FULLSCREEN = "fullScreen";
    public static final String PROPERTY_POSITION = "windowPosition";
    public static final String PROPERTY_SIZE = "windowSize";
    public static final String PROPERTY_CONFIRM_EXIT = "confirmExit";
    public static final String PROPERTY_CONFIRM_QUERY_ENDED = "confirmQueryEnded";
    private final String storageFolder = "data/gui/";
    private final String storageFileQ = "lastQueries.ser";
    private final String storageFileA = "lastAnswers.ser";
    private final String storageFileF = "lastFiles.ser";
    private final String storageFileC = "config.properties";
    private RecentFileList queries;
    private RecentFileList answers;
    private RecentFileList files;
    private Properties guiConfig;
    private static Storage instance = new Storage();

    private Storage() {
        this.loadData();
        if (this.queries == null) {
            this.queries = new RecentFileList();
        }
        if (this.answers == null) {
            this.answers = new RecentFileList();
        }
        if (this.files == null) {
            this.files = new RecentFileList();
        }
        this.resetGuiConfig(false);
        this.loadGuiConfig();
    }

    public static Storage getInstance() {
        return instance;
    }

    public void store(File file, int type) {
        switch (type) {
            case 1: {
                this.answers.add(file);
                break;
            }
            case 0: {
                this.queries.add(file);
                break;
            }
            default: {
                this.files.add(file);
            }
        }
        this.saveData();
    }

    private void loadData() {
        ObjectInputStream in;
        FileInputStream fileIn;
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileQ);
            in = new ObjectInputStream(fileIn);
            this.queries = (RecentFileList)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.msg("Could not load last queries.", 6);
        }
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileA);
            in = new ObjectInputStream(fileIn);
            this.answers = (RecentFileList)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.msg("Could not load last answers.", 6);
        }
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileF);
            in = new ObjectInputStream(fileIn);
            this.files = (RecentFileList)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.msg("Could not load last used files.", 6);
        }
        boolean changed = false;
        if (this.queries != null) {
            for (int i = 0; i < this.queries.size(); ++i) {
                if (((File)this.queries.get(i)).exists()) continue;
                this.queries.remove(i);
                --i;
                changed = true;
            }
        }
        if (this.answers != null) {
            for (int i = 0; i < this.answers.size(); ++i) {
                if (((File)this.answers.get(i)).exists()) continue;
                this.answers.remove(i);
                --i;
                changed = true;
            }
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.size(); ++i) {
                if (((File)this.files.get(i)).exists()) continue;
                this.files.remove(i);
                --i;
                changed = true;
            }
        }
        if (changed) {
            this.saveData();
        }
    }

    private void loadGuiConfig() {
        try (FileInputStream fis = new FileInputStream(this.storageFolder + this.storageFileC);){
            this.guiConfig.load(fis);
        }
        catch (IOException e) {
            Log.msg("Could not load GUI config file.", 6);
        }
    }

    private void saveData() {
        FileOutputStream fileOut;
        int j;
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        for (int i = 0; i < this.queries.size(); ++i) {
            File q1 = (File)this.queries.get(i);
            for (j = i + 1; j < this.queries.size(); ++j) {
                File q2 = (File)this.queries.get(j);
                if (!q1.getAbsolutePath().equals(q2.getAbsolutePath())) continue;
                toRemove.add(i);
            }
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            this.queries.remove(i2);
        }
        toRemove.clear();
        for (int i3 = 0; i3 < this.answers.size(); ++i3) {
            File a1 = (File)this.answers.get(i3);
            for (j = i3 + 1; j < this.answers.size(); ++j) {
                File a2 = (File)this.answers.get(j);
                if (!a1.getAbsolutePath().equals(a2.getAbsolutePath())) continue;
                toRemove.add(i3);
            }
        }
        Iterator i3 = toRemove.iterator();
        while (i3.hasNext()) {
            int i4 = (Integer)i3.next();
            this.answers.remove(i4);
        }
        toRemove.clear();
        for (int i5 = 0; i5 < this.files.size(); ++i5) {
            File f1 = (File)this.files.get(i5);
            for (j = i5 + 1; j < this.files.size(); ++j) {
                File f2 = (File)this.files.get(j);
                if (!f1.getAbsolutePath().equals(f2.getAbsolutePath())) continue;
                toRemove.add(i5);
            }
        }
        Iterator i5 = toRemove.iterator();
        while (i5.hasNext()) {
            int i6 = (Integer)i5.next();
            this.files.remove(i6);
        }
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileQ);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.queries);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.msg("Could not save last queries." + Log.getExceptionAppendix(e), 5);
        }
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileA);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.answers);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.msg("Could not save last answers." + Log.getExceptionAppendix(e), 5);
        }
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileF);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.files);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.msg("Could not save last used files." + Log.getExceptionAppendix(e), 5);
        }
    }

    private void saveGuiConfig() {
        try (FileWriter fw = new FileWriter(this.storageFolder + this.storageFileC);){
            this.guiConfig.store(fw, null);
        }
        catch (IOException e) {
            Log.msg("Could not save GUI config file." + Log.getExceptionAppendix(e), 5);
        }
    }

    public List<File> getRecentFiles(int type) {
        switch (type) {
            case 1: {
                return this.answers.getRecentFiles();
            }
            case 0: {
                return this.queries.getRecentFiles();
            }
        }
        return this.files.getRecentFiles();
    }

    public void setGuiConfigProperty(String property, String value) {
        this.guiConfig.setProperty(property, value);
        this.saveGuiConfig();
    }

    public String getGuiConfigProperty(String property) {
        return this.guiConfig.getProperty(property);
    }

    public void resetGuiConfig() {
        this.resetGuiConfig(true);
    }

    public void resetGuiConfig(boolean deleteFile) {
        this.guiConfig = new Properties();
        this.guiConfig.setProperty(PROPERTY_CONFIRM_QUERY_ENDED, Boolean.TRUE.toString());
        if (deleteFile) {
            File guiConfigFile = new File(this.storageFolder + this.storageFileC);
            try {
                Files.delete(guiConfigFile.toPath());
            }
            catch (IOException e) {
                Log.msg("Could not reset GUI configuration file." + Log.getExceptionAppendix(e), 5);
            }
        }
    }
}

