/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.helper.GUIHelper;
import de.foellix.aql.system.IAnswerAvailable;
import de.foellix.aql.system.storage.StorageEntry;
import de.foellix.aql.system.storage.StorageExplorer;
import de.foellix.aql.ui.gui.Viewer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class StorageOverview
extends TitledPane
implements IAnswerAvailable {
    private static final int SORT_BY_ID = 0;
    private static final int SORT_BY_SOI = 1;
    private static final int SORT_BY_DATE = 2;
    private static final int SORT_BY_FILE = 3;
    private final StorageExplorer storageExplorer = new StorageExplorer();
    private final ListView<StorageEntry> listView = new ListView();
    private TextArea details;
    private TextField search;
    private CheckBox searchInAnswer;
    private int currentSort;
    private FilteredList<StorageEntry> sortedData;

    StorageOverview(Viewer parent) {
        this.listView.getSelectionModel().selectedItemProperty().addListener((obs, oldValue, newValue) -> {
            if (this.listView.getSelectionModel().getSelectedItem() != null) {
                this.details.setText(((StorageEntry)this.listView.getSelectionModel().getSelectedItem()).getRunCmd());
            }
        });
        this.listView.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                parent.openFile(((StorageEntry)this.listView.getSelectionModel().getSelectedItem()).getAnswer().getAnswerFile());
            }
        });
        this.listView.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.SPACE || e.getCode() == KeyCode.ENTER) {
                parent.openFile(((StorageEntry)this.listView.getSelectionModel().getSelectedItem()).getAnswer().getAnswerFile());
            } else if (e.getCode() == KeyCode.DELETE) {
                for (StorageEntry entry : this.listView.getSelectionModel().getSelectedItems()) {
                    this.storageExplorer.delete(entry);
                }
                this.refresh();
            }
        });
        this.listView.setPrefHeight(200.0);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.details = new TextArea("Please select an entry.");
        this.details.setEditable(false);
        this.details.setWrapText(true);
        this.details.setPrefHeight(125.0);
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{new Label("Run command:"), this.details});
        box.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        HBox options = new HBox(5.0);
        options.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        this.search = new TextField();
        this.search.setPadding(new Insets(2.0));
        this.search.textProperty().addListener(obs -> this.filter());
        HBox.setHgrow((Node)this.search, (Priority)Priority.ALWAYS);
        this.searchInAnswer = new CheckBox();
        this.searchInAnswer.setTooltip(new Tooltip("WARNING: For huge answers enabling this option may cause performance issues!"));
        this.searchInAnswer.setSelected(false);
        this.searchInAnswer.setOnAction(e -> this.filter());
        RadioButton sortById = new RadioButton("ID");
        sortById.setUserData((Object)0);
        RadioButton sortBySoi = new RadioButton("Subject of Interest");
        sortBySoi.setUserData((Object)1);
        RadioButton sortByDate = new RadioButton("Date");
        sortByDate.setUserData((Object)2);
        RadioButton sortByFile = new RadioButton("File");
        sortByFile.setUserData((Object)3);
        ToggleGroup sorting = new ToggleGroup();
        sortById.setToggleGroup(sorting);
        sortBySoi.setToggleGroup(sorting);
        sortByDate.setToggleGroup(sorting);
        sortByFile.setToggleGroup(sorting);
        sortById.setSelected(true);
        sorting.selectedToggleProperty().addListener((obj, old, current) -> {
            if (current.getUserData() != null) {
                this.currentSort = (Integer)current.getUserData();
                this.refresh();
            }
        });
        options.getChildren().addAll((Object[])new Node[]{new Label("Search for:"), this.search, new Label("also in answer:"), this.searchInAnswer, new Separator(Orientation.VERTICAL), new Label("Sort by:"), sortById, sortBySoi, sortByDate, sortByFile});
        BorderPane pane = new BorderPane();
        pane.setTop((Node)options);
        pane.setCenter(this.listView);
        pane.setBottom((Node)box);
        GUIHelper.makeResizableInHeight((Region)pane, 350);
        this.setText("Storage-Overview");
        this.setExpanded(false);
        this.setContent((Node)pane);
        this.currentSort = 0;
        this.refresh();
    }

    private void filter() {
        String needle = this.search.getText().toLowerCase();
        if (needle == null || needle.length() == 0) {
            this.sortedData.setPredicate(s -> true);
        } else if (this.searchInAnswer.isSelected()) {
            this.sortedData.setPredicate(s -> s.toString().toLowerCase().contains(needle) || s.getRunCmd().toLowerCase().contains(needle) || s.getAnswer().getRawContent().toLowerCase().contains(needle));
        } else {
            this.sortedData.setPredicate(s -> s.toString().toLowerCase().contains(needle) || s.getRunCmd().toLowerCase().contains(needle));
        }
        this.listView.setItems(this.sortedData);
    }

    public void refresh() {
        this.storageExplorer.init();
        ObservableList list = FXCollections.observableArrayList();
        switch (this.currentSort) {
            case 1: {
                list.addAll(this.storageExplorer.getSortedBySoi());
                break;
            }
            case 2: {
                list.addAll(this.storageExplorer.getSortedByDate());
                break;
            }
            case 3: {
                list.addAll(this.storageExplorer.getSortedByFile());
                break;
            }
            default: {
                list.addAll(this.storageExplorer.getSortedById());
            }
        }
        this.sortedData = new FilteredList(list);
        Platform.runLater(() -> this.filter());
    }

    @Override
    public void answerAvailable(Object answer, int status) {
        this.refresh();
    }
}

