/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.IGUI;
import de.foellix.aql.ui.gui.MenubarViewer;
import de.foellix.aql.ui.gui.StorageOverview;
import de.foellix.aql.ui.gui.ViewerXML;
import de.foellix.aql.ui.gui.viewer.web.ViewerWeb;
import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;

public class Viewer
extends BorderPane {
    private IGUI parent;
    public boolean ready = false;
    public MenubarViewer menubarViewer;
    public ViewerXML viewerXML;
    public ViewerWeb viewerWeb;

    public Viewer() {
    }

    public Viewer(IGUI parent) {
        this();
        this.init(parent);
    }

    public void init(IGUI parent) {
        this.parent = parent;
        this.setMaxHeight(Double.MAX_VALUE);
        this.setPrefHeight(Double.MAX_VALUE);
        this.menubarViewer = new MenubarViewer(this);
        this.viewerXML = new ViewerXML(this.menubarViewer);
        this.viewerWeb = new ViewerWeb(this.menubarViewer);
        parent.getSystem().getAnswerReceivers().add(this.viewerXML);
        parent.getSystem().getAnswerReceivers().add(this.viewerWeb);
        TabPane innerTabPane = new TabPane();
        final Tab tabViewerXML = new Tab("XML");
        tabViewerXML.setContent((Node)this.viewerXML);
        tabViewerXML.setClosable(false);
        Tab tabViewerWeb = new Tab("Web");
        tabViewerWeb.setContent((Node)this.viewerWeb);
        tabViewerWeb.setClosable(false);
        innerTabPane.getTabs().addAll((Object[])new Tab[]{tabViewerXML, tabViewerWeb});
        innerTabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> ov, Tab oldTab, Tab newTab) {
                if (newTab == tabViewerXML) {
                    Viewer.this.menubarViewer.buttonState(0);
                } else {
                    Viewer.this.menubarViewer.buttonState(2);
                }
            }
        });
        this.menubarViewer.buttonState(0);
        this.setTop((Node)this.menubarViewer);
        if (parent instanceof GUI) {
            StorageOverview bottomViewer = new StorageOverview(this);
            parent.getSystem().getAnswerReceivers().add(bottomViewer);
            this.setBottom((Node)bottomViewer);
        }
        this.setCenter((Node)innerTabPane);
    }

    public boolean isReady() {
        return this.ready;
    }

    public void openFile(File file) {
        Answer temp = AnswerHandler.parseXML(file);
        this.openAnswer(temp);
    }

    public void openAnswer(Answer answer) {
        this.viewerXML.answerAvailable(answer, 0);
        this.viewerWeb.answerAvailable(answer, 0);
    }

    public void refreshGraph() {
        Answer temp = AnswerHandler.parseXML(this.viewerXML.getContent());
        this.viewerWeb.answerAvailable(temp, 0);
    }

    public IGUI getParentGUI() {
        return this.parent;
    }

    public void inBrowser() {
        this.viewerWeb.inBrowser();
    }

    public void resetContent() {
        this.viewerXML.resetContent();
        this.viewerWeb.answerAvailable(new Answer(), 0);
    }
}

