/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui.viewer.web;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.Helper;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private int id;
    private Object item;
    private List<Reference> refs;

    public Node(int id, Object item) {
        this.id = id;
        this.item = item;
        this.refs = new ArrayList<Reference>();
    }

    public int getId() {
        return this.id;
    }

    public Object getItem() {
        return this.item;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public String toElement() {
        String xml;
        Object label;
        String color = "#ededed";
        if (this.item instanceof Intentsource) {
            color = "#f29c9c";
            label = ((Intentsource)this.item).getTarget() != null ? (((Intentsource)this.item).getTarget().getAction() != null && !((Intentsource)this.item).getTarget().getAction().isEmpty() ? ((Intentsource)this.item).getTarget().getAction() + "\n" + (((Intentsource)this.item).getTarget().getCategory() == null ? "-" : ((Intentsource)this.item).getTarget().getCategory()) : (((Intentsource)this.item).getTarget().getReference() != null && ((Intentsource)this.item).getTarget().getReference().getClassname() != null ? ((Intentsource)this.item).getTarget().getReference().getClassname() : "No short info except:\nImplicit without action")) : "No target info!";
        } else if (this.item instanceof Intentsink) {
            color = "#c0d6a3";
            label = ((Intentsink)this.item).getTarget() != null ? (((Intentsink)this.item).getTarget().getAction() != null && !((Intentsink)this.item).getTarget().getAction().isEmpty() ? ((Intentsink)this.item).getTarget().getAction() + "\n" + (((Intentsink)this.item).getTarget().getCategory() == null ? "-" : ((Intentsink)this.item).getTarget().getCategory()) : (((Intentsink)this.item).getTarget().getReference() != null && ((Intentsink)this.item).getTarget().getReference().getClassname() != null ? ((Intentsink)this.item).getTarget().getReference().getClassname() : "No short info except:\nImplicit without action")) : "No target info!";
        } else if (this.item instanceof Permission) {
            color = "#d6ace4";
            label = ((Permission)this.item).getName().replace("android.permission", "... ");
        } else if (this.item instanceof Reference) {
            color = this.refs.isEmpty() ? "#a3c3d6" : "#a3d6d6";
            Object statement = ((Reference)this.item).getStatement().getStatementfull();
            if (((String)statement).contains("<init>")) {
                statement = ((String)statement).substring(0, ((String)statement).indexOf(58));
                statement = ((String)statement).substring(((String)statement).lastIndexOf(46) + 1) + " <init>";
            } else if (((String)statement).contains("<clinit>")) {
                statement = ((String)statement).substring(0, ((String)statement).indexOf(58));
                statement = ((String)statement).substring(((String)statement).lastIndexOf(46) + 1) + " <clinit>";
            } else if (Helper.cut((String)(statement = Helper.cut(Helper.cut((String)statement, "<", ">"), " ", -1)), "(", ")").length() > 22) {
                statement = Helper.cutFromStart((String)statement, "(") + "(..)";
            }
            Object app = Helper.cut(Helper.cut(((Reference)this.item).getApp().getFile(), "/", -1), "\\", -1);
            if (((String)app).length() >= 34) {
                app = ((String)app).substring(0, 28) + "...apk";
            }
            label = (String)statement + "\n" + Helper.cut(((Reference)this.item).getMethod(), " ", ">", -1) + "\n" + Helper.cut(((Reference)this.item).getClassname(), ".", -1) + "\n" + (String)app;
        } else {
            label = super.toString();
        }
        int height = this.height((String)label);
        int width = this.width((String)label);
        label = this.escape((String)label);
        int counter = 1;
        StringBuilder verbose = new StringBuilder(counter + ") " + this.escape(Helper.toString(this.item)));
        if (!this.refs.isEmpty() && this.item instanceof Reference) {
            Flow flow = new Flow();
            flow.getReference().add((Reference)this.item);
            for (Reference ref : this.refs) {
                flow.getReference().add(ref);
                verbose.append(this.escape("\n\n" + ++counter + ") " + Helper.toString(ref)));
            }
            Answer answerXML = new Answer();
            answerXML.setFlows(new Flows());
            answerXML.getFlows().getFlow().add(flow);
            xml = this.escape(AnswerHandler.createXMLString(answerXML));
        } else {
            xml = this.escape(AnswerHandler.createXMLString(this.item));
        }
        return "{ \"data\": { \"id\": \"" + this.id + "\", \"label\": \"" + (String)label + "\", \"width\": \"" + width + "px\", \"height\": \"" + height + "px\", \"color\": \"" + color + "\", \"verbose\": \"" + verbose + "\", \"xml\": \"" + xml + "\" }},";
    }

    private int width(String label) {
        int max = 0;
        for (String line : label.split("\\n")) {
            if (line.length() <= max) continue;
            max = line.length();
        }
        return max * 7;
    }

    private int height(String label) {
        return Math.max(1, Helper.countStringOccurences(label, "\n")) * 17;
    }

    private String escape(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }

    public void addReference(Reference ref1) {
        EqualsOptions options = new EqualsOptions();
        options.setOption(1, true);
        if (EqualsHelper.equals(ref1, (Reference)this.item, options)) {
            return;
        }
        for (Reference ref2 : this.refs) {
            if (!EqualsHelper.equals(ref1, ref2, options)) continue;
            return;
        }
        this.refs.add(ref1);
    }
}

