/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui.viewer.web;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.RAWIdentifier;
import de.foellix.aql.ui.gui.viewer.web.Edge;
import de.foellix.aql.ui.gui.viewer.web.Node;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WebRepresentation {
    private int counter;
    private Map<String, Node> map = new HashMap<String, Node>();
    private Collection<Edge> edges = new ArrayList<Edge>();

    public String toJson(Answer answer) {
        return this.toJson(answer, true);
    }

    public String toJson(Answer answer, boolean considerLinenumbers) {
        Serializable temp;
        Node ref;
        this.counter = 0;
        this.map.clear();
        this.edges.clear();
        RAWIdentifier raw = new RAWIdentifier(true, considerLinenumbers);
        if (answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty()) {
            for (Flow flow : answer.getFlows().getFlow()) {
                Reference fromRef = Helper.getFrom(flow.getReference());
                Reference toRef = Helper.getTo(flow.getReference());
                if (fromRef == null || toRef == null) continue;
                Node from = this.addNode(fromRef, raw);
                Node to = this.addNode(toRef, raw);
                ++this.counter;
                int style = 0;
                if (flow.getAttributes() != null) {
                    for (Attribute attribute : flow.getAttributes().getAttribute()) {
                        if (!attribute.getName().equals("complete") || !attribute.getValue().equals("true")) continue;
                        style = 3;
                        break;
                    }
                }
                ArrayList<Flow> toCandidates = new ArrayList<Flow>();
                for (Flow temp2 : answer.getFlows().getFlow()) {
                    Reference reference;
                    if (temp2 == flow || !EqualsHelper.equals(toRef, reference = Helper.getTo(temp2), EqualsOptions.DEFAULT.setOption(1, true))) continue;
                    toCandidates.add(temp2);
                }
                ArrayList<Flow> arrayList = new ArrayList<Flow>();
                for (Flow flow2 : answer.getFlows().getFlow()) {
                    Reference tempFrom;
                    if (flow2 == flow || !EqualsHelper.equals(fromRef, tempFrom = Helper.getFrom(flow2), EqualsOptions.DEFAULT.setOption(1, true))) continue;
                    arrayList.add(flow2);
                }
                for (Flow flow3 : toCandidates) {
                    Reference commonFrom = Helper.getFrom(flow3);
                    for (Flow tempFrom : arrayList) {
                        Reference commonTo = Helper.getTo(tempFrom);
                        if (!EqualsHelper.equals(commonFrom, commonTo, EqualsOptions.DEFAULT.setOption(1, true))) continue;
                        if (style == 0) {
                            style = 1;
                            break;
                        }
                        style = 2;
                        break;
                    }
                    if (style == 0) continue;
                    break;
                }
                this.edges.add(new Edge(this.counter, from, to, style));
            }
        }
        if (answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty()) {
            for (Permission permission : answer.getPermissions().getPermission()) {
                if (permission.getReference() == null) continue;
                ref = this.addNode(permission.getReference(), raw);
                Node permission2 = this.addNode(permission, raw);
                ++this.counter;
                this.edges.add(new Edge(this.counter, permission2, ref, 6));
            }
        }
        if (answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty()) {
            for (Intentsink intentsink : answer.getIntentsinks().getIntentsink()) {
                if (intentsink.getReference() == null) continue;
                ref = this.addNode(intentsink.getReference(), raw);
                temp = new Intentsink();
                ((Intentsink)temp).setTarget(intentsink.getTarget());
                ((Intentsink)temp).setAttributes(intentsink.getAttributes());
                Node intentsink2 = this.addNode(temp, raw);
                ++this.counter;
                this.edges.add(new Edge(this.counter, intentsink2, ref, 4));
            }
        }
        if (answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty()) {
            for (Intentsource intentsource : answer.getIntentsources().getIntentsource()) {
                if (intentsource.getReference() == null) continue;
                ref = this.addNode(intentsource.getReference(), raw);
                temp = new Intentsource();
                ((Intentsource)temp).setTarget(intentsource.getTarget());
                ((Intentsource)temp).setAttributes(intentsource.getAttributes());
                Node intentsource2 = this.addNode(temp, raw);
                ++this.counter;
                this.edges.add(new Edge(this.counter, intentsource2, ref, 5));
            }
        }
        StringBuilder sb = new StringBuilder("{ \"nodes\": [");
        for (Node node : this.map.values()) {
            sb.append(node.toElement());
        }
        sb.setLength(sb.length() - 1);
        sb.append("], \"edges\": [");
        for (Edge edge : this.edges) {
            sb.append(edge.toElement());
        }
        sb.setLength(sb.length() - 1);
        sb.append("] }");
        return sb.toString();
    }

    private Node addNode(Object obj, RAWIdentifier raw) {
        String identifier = raw.toRAW(obj);
        if (!this.map.containsKey(identifier)) {
            ++this.counter;
            Node node = new Node(this.counter, obj);
            this.map.put(identifier, node);
            return node;
        }
        Node node = this.map.get(identifier);
        if (obj instanceof Reference) {
            node.addReference((Reference)obj);
        }
        return node;
    }
}

