/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.exchange.write;

import de.galan.dmsexchange.exchange.ConditionalDmsWriter;
import de.galan.dmsexchange.exchange.DmsWriter;
import de.galan.dmsexchange.exchange.write.DefaultDmsWriter;
import de.galan.dmsexchange.exchange.write.condition.SplitCondition;
import de.galan.dmsexchange.meta.Document;
import de.galan.dmsexchange.util.DmsExchangeException;
import de.galan.dmsexchange.util.FileGenerationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefaultConditionalDmsWriter
implements ConditionalDmsWriter {
    private DmsWriter writer;
    private File directory;
    private List<File> files;
    private List<SplitCondition> conditions;
    private int documentsAdded;
    private FileOutputStream currentFileOutputStream;

    public DefaultConditionalDmsWriter(File directory) throws DmsExchangeException {
        if (directory == null || !directory.isDirectory()) {
            throw new DmsExchangeException("File passed to ConditionalDmsWriter must be an existing directory");
        }
        this.directory = directory;
        this.conditions = new ArrayList<SplitCondition>();
        this.files = new ArrayList<File>();
        this.documentsAdded = 0;
        this.setWriter(this.getNextWriter());
    }

    public void addCondition(SplitCondition condition) {
        this.conditions.add(condition);
    }

    protected DmsWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(DmsWriter writer) {
        this.writer = writer;
    }

    protected File getCurrentFile() {
        return this.getFiles().get(this.getFiles().size() - 1);
    }

    @Override
    public void add(Document document) throws DmsExchangeException {
        if (this.conditions.stream().anyMatch(c -> c.evaluate(this.getCurrentFile(), this.documentsAdded))) {
            this.split();
        }
        this.writer.add(document);
        try {
            this.currentFileOutputStream.flush();
        }
        catch (IOException ex) {
            throw new DmsExchangeException("Unable to flush data to file", ex);
        }
        ++this.documentsAdded;
    }

    protected void split() throws DmsExchangeException {
        try {
            this.getWriter().close();
        }
        catch (Exception ex) {
            throw new DmsExchangeException("Unable to close splitted export-archive", ex);
        }
        this.setWriter(this.getNextWriter());
        this.documentsAdded = 0;
    }

    protected DmsWriter getNextWriter() throws DmsExchangeException {
        File file = this.getNextFile();
        try {
            this.currentFileOutputStream = new FileOutputStream(file);
            return new DefaultDmsWriter(this.currentFileOutputStream);
        }
        catch (FileNotFoundException ex) {
            throw new DmsExchangeException("Unable to create file '" + file.getAbsolutePath() + "'", ex);
        }
    }

    protected File getNextFile() throws DmsExchangeException {
        try {
            File result = FileGenerationUtil.generateUniqueFilename(this.directory);
            this.files.add(result);
            return result;
        }
        catch (Exception ex) {
            throw new DmsExchangeException("Unable to create unique filename in directory", ex);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.getWriter() != null) {
            this.getWriter().close();
        }
    }

    @Override
    public List<File> getFiles() {
        return this.files;
    }
}

