/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.exchange.write;

import de.galan.dmsexchange.exchange.DefaultExchange;
import de.galan.dmsexchange.exchange.DmsWriter;
import de.galan.dmsexchange.exchange.DocumentValidationException;
import de.galan.dmsexchange.exchange.container.ContainerSerializer;
import de.galan.dmsexchange.exchange.write.DocumentAddedEvent;
import de.galan.dmsexchange.exchange.write.DocumentAddedFailedEvent;
import de.galan.dmsexchange.exchange.write.DocumentAddedLoggingListener;
import de.galan.dmsexchange.meta.Document;
import de.galan.dmsexchange.util.DmsExchangeException;
import de.galan.dmsexchange.util.archive.TarUtil;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.lang3.StringUtils;

public class DefaultDmsWriter
extends DefaultExchange
implements DmsWriter {
    private static final String ZERO = "0";
    private static final String EXTENSION = ".tar";
    private static final String SLASH = "/";
    private long counterContainer = 0L;
    private ContainerSerializer serializer = new ContainerSerializer();
    private TarArchiveOutputStream tar;
    private boolean closed = false;

    public DefaultDmsWriter(OutputStream outputstream) throws DmsExchangeException {
        try {
            this.tar = TarUtil.create(outputstream, true);
        }
        catch (IOException ex) {
            throw new DmsExchangeException("Unable to create archive stream", ex);
        }
        this.registerListener(new DocumentAddedLoggingListener());
    }

    @Override
    public void add(Document document) throws DmsExchangeException {
        if (this.isClosed()) {
            throw new DmsExchangeException("The export-archive is already closed");
        }
        try {
            String pathForContainer = this.getNextContainerPath();
            byte[] container = this.serializer.archive(document, false);
            TarUtil.addEntry(this.tar, container, pathForContainer);
            this.postEvent(new DocumentAddedEvent(document));
        }
        catch (DocumentValidationException ex) {
            this.postEvent(new DocumentAddedFailedEvent(document, ex.getValidationResult()));
            throw ex;
        }
        catch (IOException ex) {
            this.postEvent(new DocumentAddedFailedEvent(document, null, ex));
            throw new DmsExchangeException("Failed adding", ex);
        }
    }

    protected String getNextContainerPath() throws DmsExchangeException {
        if (this.counterContainer - 1L > 1000000000000L) {
            throw new DmsExchangeException("Limit for containers in single archive exceeded");
        }
        String string = StringUtils.leftPad((String)("" + this.counterContainer++), (int)12, (String)ZERO);
        StringBuffer result = new StringBuffer();
        result.append(StringUtils.substring((String)string, (int)0, (int)4));
        result.append(SLASH);
        result.append(StringUtils.substring((String)string, (int)4, (int)8));
        result.append(SLASH);
        result.append(StringUtils.substring((String)string, (int)8, (int)12));
        result.append(EXTENSION);
        return result.toString();
    }

    @Override
    public void close() throws DmsExchangeException {
        if (!this.isClosed()) {
            try {
                if (this.tar != null) {
                    this.tar.close();
                }
            }
            catch (IOException ex) {
                throw new DmsExchangeException("Unable to close tar stream", ex);
            }
            this.closed = true;
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }
}

