/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import de.galan.dmsexchange.meta.User;
import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.UtcFormatter;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Comment
implements Validatable {
    private User commentBy;
    private ZonedDateTime commentTime;
    private String content;

    public Comment() {
    }

    public Comment(User commentBy, ZonedDateTime commentTime, String content) {
        this.setCommentBy(commentBy);
        this.setCommentTime(commentTime);
        this.setContent(content);
    }

    @Override
    public void validate(ValidationResult result) {
        if (this.getCommentBy() == null) {
            result.add("No user for comment");
        } else {
            this.getCommentBy().validate(result);
        }
        if (this.getCommentTime() == null) {
            result.add("No time for comment");
        }
        if (this.getContent() == null) {
            result.add("No content for comment");
        }
    }

    public User getCommentBy() {
        return this.commentBy;
    }

    public void setCommentBy(User commentBy) {
        this.commentBy = commentBy;
    }

    public Comment commentBy(User commentBy) {
        this.setCommentBy(commentBy);
        return this;
    }

    public Comment commentBy(String commentBy) {
        this.setCommentBy(new User(commentBy));
        return this;
    }

    public ZonedDateTime getCommentTime() {
        return this.commentTime;
    }

    public void setCommentTime(ZonedDateTime commentTime) {
        this.commentTime = commentTime;
    }

    public Comment commentTime(ZonedDateTime commentTime) {
        this.setCommentTime(commentTime);
        return this;
    }

    public Comment commentTime(String commentTime) {
        this.setCommentTime(UtcFormatter.parse(commentTime));
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Comment content(String content) {
        this.setContent(content);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.commentBy, this.content, this.commentTime);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Comment) {
            Comment other = (Comment)obj;
            return new EqualsBuilder().append((Object)this.commentBy, (Object)other.commentBy).append((Object)this.commentTime, (Object)other.commentTime).append((Object)this.content, (Object)other.content).isEquals();
        }
        return false;
    }
}

