/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.UtcFormatter;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Context
implements Validatable {
    private ZonedDateTime documentTime;
    private ZonedDateTime dueDateTime;

    public Context() {
    }

    public Context(ZonedDateTime documentTime, ZonedDateTime dueDateTime) {
        this.setDocumentTime(documentTime);
        this.setDueDateTime(dueDateTime);
    }

    @Override
    public void validate(ValidationResult result) {
    }

    public ZonedDateTime getDocumentTime() {
        return this.documentTime;
    }

    public void setDocumentTime(ZonedDateTime documentTime) {
        this.documentTime = documentTime;
    }

    public Context documentTime(ZonedDateTime documentTime) {
        this.setDocumentTime(documentTime);
        return this;
    }

    public Context documentTime(String documentTime) {
        this.setDocumentTime(UtcFormatter.parse(documentTime));
        return this;
    }

    public ZonedDateTime getDueDateTime() {
        return this.dueDateTime;
    }

    public void setDueDateTime(ZonedDateTime dueDateTime) {
        this.dueDateTime = dueDateTime;
    }

    public Context dueDateTime(ZonedDateTime dueDateTime) {
        this.setDueDateTime(dueDateTime);
        return this;
    }

    public Context dueDateTime(String dueDateTime) {
        this.setDueDateTime(UtcFormatter.parse(dueDateTime));
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.documentTime, this.dueDateTime);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Context) {
            Context other = (Context)obj;
            return new EqualsBuilder().append((Object)this.documentTime, (Object)other.documentTime).append((Object)this.dueDateTime, (Object)other.dueDateTime).isEquals();
        }
        return false;
    }
}

