/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.EmailValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Source
implements Validatable {
    private String name;
    private String version;
    private String url;
    private String email;

    public Source() {
    }

    public Source(String name, String version, String url, String email) {
        this.name = name;
        this.version = version;
        this.url = url;
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return "Source [name=" + this.name + ", version=" + this.version + ", url=" + this.url + ", email=" + this.email + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.url, this.email);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Source) {
            Source other = (Source)obj;
            return new EqualsBuilder().append((Object)this.name, (Object)other.name).append((Object)this.version, (Object)other.version).append((Object)this.url, (Object)other.url).append((Object)this.email, (Object)other.email).isEquals();
        }
        return false;
    }

    @Override
    public void validate(ValidationResult result) {
        if (this.getUrl() != null && !this.isValidUrl(this.getUrl())) {
            result.add("Invalid URL for source URL");
        }
        if (this.getEmail() != null && !EmailValidation.isValidEmailAddress(this.getEmail())) {
            result.add("Invalid email-address for source email");
        }
    }

    private boolean isValidUrl(String validateUrl) {
        boolean result = true;
        try {
            new URL(validateUrl);
        }
        catch (MalformedURLException ex) {
            result = false;
        }
        return result;
    }
}

