/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.util.archive;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class TarUtil {
    public static TarArchiveOutputStream create(OutputStream outputstream, boolean compress) throws IOException {
        return new TarArchiveOutputStream((OutputStream)(compress ? new GzipCompressorOutputStream(outputstream) : outputstream));
    }

    public static void addEntry(TarArchiveOutputStream tar, byte[] data, String name) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize((long)data.length);
        tar.putArchiveEntry((ArchiveEntry)entry);
        tar.write(data);
        tar.closeArchiveEntry();
        tar.flush();
    }
}

