/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.exchange.container;

import com.fasterxml.jackson.databind.JsonNode;
import de.galan.dmsexchange.exchange.container.AbstractContainer;
import de.galan.dmsexchange.meta.Document;
import de.galan.dmsexchange.meta.DocumentFile;
import de.galan.dmsexchange.meta.Revision;
import de.galan.dmsexchange.util.InvalidArchiveException;
import de.galan.dmsexchange.util.Version;
import de.galan.verjson.core.IOReadException;
import de.galan.verjson.core.NamespaceMismatchException;
import de.galan.verjson.core.VersionNotSupportedException;
import de.galan.verjson.step.ProcessStepException;
import de.galan.verjson.util.Transformations;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ContainerDeserializer
extends AbstractContainer {
    private static final Pattern REVISION_PATTERN = Pattern.compile("^revisions/[0-9]{4}[01][0-9][0-3][0-9]T[0-2][0-9]([0-5][0-9]){2}Z_.*");

    protected Document unarchive(byte[] data, boolean standalone) throws InvalidArchiveException, VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException, IOException {
        return this.unarchive(new ByteArrayInputStream(data), standalone);
    }

    public Document unarchive(InputStream is, boolean standalone) throws IOException, InvalidArchiveException, VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException {
        Document result = null;
        HashMap<String, byte[]> revisions = new HashMap<String, byte[]>();
        TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)(standalone ? new GzipCompressorInputStream(is) : is));
        TarArchiveEntry entry = null;
        while ((entry = tar.getNextTarEntry()) != null) {
            if (entry.isDirectory()) continue;
            if (this.isMetadata(entry.getName())) {
                result = this.readMeta(IOUtils.toByteArray((InputStream)tar));
                continue;
            }
            if (this.isRevision(entry.getName())) {
                byte[] baos = IOUtils.toByteArray((InputStream)tar);
                revisions.put(entry.getName(), baos);
                continue;
            }
            throw new InvalidArchiveException("Container has invalid files ('" + entry.getName() + "')");
        }
        if (result == null) {
            throw new InvalidArchiveException("Container is empty");
        }
        this.merge(result, revisions);
        return result;
    }

    protected void merge(Document result, Map<String, byte[]> revisions) throws InvalidArchiveException {
        for (DocumentFile df : result.getDocumentFiles()) {
            for (Revision revision : df.getRevisions()) {
                String generated = this.generateRevisionName(df, revision);
                byte[] data = revisions.get(generated);
                if (data == null || data.length == 0) {
                    throw new InvalidArchiveException("Revision for '" + generated + "' not found");
                }
                revision.setData(data);
            }
        }
    }

    protected Document readMeta(byte[] metaBytes) throws IOException, InvalidArchiveException, VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException {
        String metaString = new String(metaBytes, StandardCharsets.UTF_8);
        JsonNode metaNode = this.getVerjson().readTree(metaString);
        long version = this.determineVersion(metaNode);
        return (Document)this.getVerjson().readPlain(metaNode, version);
    }

    protected long determineVersion(JsonNode metaNode) throws InvalidArchiveException {
        String version = null;
        try {
            version = Transformations.obj((JsonNode)metaNode).get("version").asText();
        }
        catch (Exception ex) {
            throw new InvalidArchiveException("Unable to determine version from meta.json");
        }
        Long result = Version.getVerjson(version);
        if (result == null) {
            throw new InvalidArchiveException("Version '" + version + "' not supported");
        }
        return result;
    }

    protected boolean isMetadata(String name) {
        return StringUtils.equals((CharSequence)name, (CharSequence)"meta.json");
    }

    protected boolean isRevision(String name) {
        return REVISION_PATTERN.matcher(name).matches();
    }
}

